from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ActiveAffinityType')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereActiveAffinityType");
  exportedObject.put("roleName", "WebSphereActiveAffinityType");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.activeaffinitytype.expirationtime", objid, "expirationTime","ActiveAffinityType");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ActiveAffinityType');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ActiveAffinityType')
  if not jsonobject.has("roleProperties"):
    raise Exception("ActiveAffinityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "expirationTime", roleProperties.optString("websphere.activeaffinitytype.expirationtime", None));
  print "Creating ActiveAffinityType with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ActiveAffinityType", parentid, properties);
  Util.popPathElement('ActiveAffinityType');

def update(objid,jsonobject):
  Util.pushPathElement('ActiveAffinityType')
  if not jsonobject.has("roleProperties"):
    raise Exception("ActiveAffinityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.activeaffinitytype.expirationtime", None), "expirationTime","ActiveAffinityType");
  if len(atts) != 0:
    print "Modifying ActiveAffinityType with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ActiveAffinityType configuration up to date.";

  Util.popPathElement('ActiveAffinityType');
