from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Component import Component
from utilities import Util
from Property import Property
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Agent')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAgent");
  exportedObject.put("roleName", "WebSphereAgent");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.agent.name", objid, "name","Agent");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "Agent");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "Agent");
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Agent");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"Agent");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Agent');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('Agent')
  if not jsonobject.has("roleProperties"):
    raise Exception("Agent resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.agent.name", None));
  print "Creating Agent with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Agent", parentid, properties);

  Component.removeComponents(objid, 'components', "Agent");
  Service.removeServices(objid, 'services', "Agent");
  Property.removeProperties(objid, 'properties',"Agent");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"Agent");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);      
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('Agent');


def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('Agent')
  if not jsonobject.has("roleProperties"):
    raise Exception("Agent resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.agent.name", None), "name","Agent");
  if len(atts) != 0:
    print "Modifying Agent with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Agent configuration up to date.";

  Component.removeComponents(objid, 'components', "Agent");
  Service.removeServices(objid, 'services', "Agent");
  Property.removeProperties(objid, 'properties',"Agent");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"Agent");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);      
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('Agent');
