from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPClonableDeviceSettingsVersion')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPClonableDeviceSettingsVersion");
  exportedObject.put("roleName", "WebSphereDPClonableDeviceSettingsVersion");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpclonabledevicesettingsversion.versionimagefilelocation", objid, "versionImageFileLocation","DPClonableDeviceSettingsVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpclonabledevicesettingsversion.versionnumber", objid, "versionNumber","DPClonableDeviceSettingsVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpclonabledevicesettingsversion.usercomment", objid, "userComment","DPClonableDeviceSettingsVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpclonabledevicesettingsversion.timecreatedinmanager", objid, "timeCreatedInManager","DPClonableDeviceSettingsVersion");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPClonableDeviceSettingsVersion");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPClonableDeviceSettingsVersion');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPClonableDeviceSettingsVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPClonableDeviceSettingsVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "versionImageFileLocation", roleProperties.optString("websphere.dpclonabledevicesettingsversion.versionimagefilelocation", None));
  Util.addIfNotNone(properties, "versionNumber", roleProperties.optString("websphere.dpclonabledevicesettingsversion.versionnumber", None));
  Util.addIfNotNone(properties, "userComment", roleProperties.optString("websphere.dpclonabledevicesettingsversion.usercomment", None));
  Util.addIfNotNone(properties, "timeCreatedInManager", roleProperties.optString("websphere.dpclonabledevicesettingsversion.timecreatedinmanager", None));
  print "Creating DPClonableDeviceSettingsVersion with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPClonableDeviceSettingsVersion", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPClonableDeviceSettingsVersion');

def update(objid,jsonobject):
  Util.pushPathElement('DPClonableDeviceSettingsVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPClonableDeviceSettingsVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpclonabledevicesettingsversion.versionimagefilelocation", None), "versionImageFileLocation","DPClonableDeviceSettingsVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpclonabledevicesettingsversion.versionnumber", None), "versionNumber","DPClonableDeviceSettingsVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpclonabledevicesettingsversion.usercomment", None), "userComment","DPClonableDeviceSettingsVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpclonabledevicesettingsversion.timecreatedinmanager", None), "timeCreatedInManager","DPClonableDeviceSettingsVersion");
  if len(atts) != 0:
    print "Modifying DPClonableDeviceSettingsVersion with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPClonableDeviceSettingsVersion configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPClonableDeviceSettingsVersion");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPClonableDeviceSettingsVersion');
