from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('IdentityAssertionQOP')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereIdentityAssertionQOP");
  exportedObject.put("roleName", "WebSphereIdentityAssertionQOP");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.identityassertionqop.trustedid", objid, "trustedId","IdentityAssertionQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.identityassertionqop.enable", objid, "enable","IdentityAssertionQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.identityassertionqop.trustedpassword", objid, "trustedPassword","IdentityAssertionQOP");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('IdentityAssertionQOP');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('IdentityAssertionQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("IdentityAssertionQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "trustedId", roleProperties.optString("websphere.identityassertionqop.trustedid", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.identityassertionqop.enable", None));
  Util.addIfNotNone(properties, "trustedPassword", roleProperties.optString("websphere.identityassertionqop.trustedpassword", None));
  print "Creating IdentityAssertionQOP with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("IdentityAssertionQOP", parentid, properties);
  Util.popPathElement('IdentityAssertionQOP');

def update(objid,jsonobject):
  Util.pushPathElement('IdentityAssertionQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("IdentityAssertionQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.identityassertionqop.trustedid", None), "trustedId","IdentityAssertionQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.identityassertionqop.enable", None), "enable","IdentityAssertionQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.identityassertionqop.trustedpassword", None), "trustedPassword","IdentityAssertionQOP");
  if len(atts) != 0:
    print "Modifying IdentityAssertionQOP with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "IdentityAssertionQOP configuration up to date.";

  Util.popPathElement('IdentityAssertionQOP');
