from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RedirectRoute')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRedirectRoute");
  exportedObject.put("roleName", "WebSphereRedirectRoute");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.redirectroute.redirecturl", objid, "redirectURL","RedirectRoute");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RedirectRoute');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RedirectRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("RedirectRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "redirectURL", roleProperties.optString("websphere.redirectroute.redirecturl", None));
  print "Creating RedirectRoute with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RedirectRoute", parentid, properties);
  Util.popPathElement('RedirectRoute');

def update(objid,jsonobject):
  Util.pushPathElement('RedirectRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("RedirectRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.redirectroute.redirecturl", None), "redirectURL","RedirectRoute");
  if len(atts) != 0:
    print "Modifying RedirectRoute with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RedirectRoute configuration up to date.";

  Util.popPathElement('RedirectRoute');
