#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2016. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
import re;
from WASConfLog import Log;
from utilities import Util
from SIBAuthGroup import SIBAuthGroup

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('SIBAuthGroupRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthGroupRef");
  exportedObject.put("roleName", "WebSphereSIBAuthGroupRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthgroup.identifier", objid, "identifier","SIBAuthGroup");

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthGroupRef');
  return result;

def create(parentid, jsonobject, parentAtt):
  Util.pushPathElement('SIBAuthGroupRef')

  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthGroupRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.sibauthgroup.identifier'):
    raise Exception("SIBAuthGroupRef resource has no property named websphere.sibauthgroup.identifier!");

  targetIdentifier = roleProperties.getString('websphere.sibauthgroup.identifier')
  parentScope = parentid[parentid.find("/"):(parentid.find("|") + 1)];

  SIBAuthGroupId = None;
  SIBAuthGroups = Util.getid("/SIBAuthGroup:/").splitlines();
  if len(SIBAuthGroups) > 0:
    for SIBAuthGroup in SIBAuthGroups:
      # see if this object id contains the same scope as the parentid
      if SIBAuthGroup.find(parentScope) != -1:
        curIdentifier = Util.getOptionalAttribute(SIBAuthGroup, "identifier", "SIBAuthGroup" );
        if curIdentifier == targetIdentifier:
          SIBAuthGroupId = SIBAuthGroup;
          break;

  if SIBAuthGroupId is None or len(SIBAuthGroupId) < 1:
    raise Exception("Could not find SIBAuthGroup with identifier %(name)s" % { 'name':targetIdentifier } );

  properties = [];
  properties.append([parentAtt, SIBAuthGroupId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating SIBAuthGroupRef to %(id)s for attribute %(att)s" % { 'id':SIBAuthGroupId, 'att':parentAtt };
  objid = Util.modify(parentid, properties);
  Log.debug("Finished Creating SIBAuthGroupRef to %(id)s for attribute %(att)s" % { 'id':SIBAuthGroupId, 'att':parentAtt });
  Util.popPathElement('SIBAuthGroupRef');
