from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ServerEntry import ServerEntry
from WASConfLog import Log
from utilities import Util

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "ServerIndex";

  containmentpath = "%(parentconpath)sServerIndex:/" % {'parentconpath':parentcontainmentpath }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ServerIndex')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServerIndex");
  exportedObject.put("roleName", "WebSphereServerIndex");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serverindex.hostname", objid, "hostName","ServerIndex");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  # server entry export has been moved into the server to better support "multiplicity" feature.
  # import/create still will handle Server Entries if it finds them to support old configurations
  # endPointRefs are managed by WebSphere and cannot be configured so we
  # will not export them.

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServerIndex');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerIndex resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ServerIndex on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;

def create(parentid, jsonobject):
  Util.pushPathElement('ServerIndex')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerIndex resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "hostName", roleProperties.optString("websphere.serverindex.hostname", None));
  print "Creating ServerIndex with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServerIndex", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereServerEntry":
        ServerEntry.create(objid, curjsonobject);
  Util.popPathElement('ServerIndex');

def update(objid,jsonobject):
  Util.pushPathElement('ServerIndex')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerIndex resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serverindex.hostname", None), "hostName","ServerIndex");
  if len(atts) != 0:
    print "Modifying ServerIndex with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServerIndex configuration up to date.";

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereServerEntry":
        #ServerIndex -> serverEntries is read-only.  We cannot do normal remove/create.
        #Have to do an update once we find the right server entry to update.
        roleProperties = curjsonobject.getJSONObject("roleProperties");
        objectName = roleProperties.optString("websphere.serverentry.servername", None);
        serverEntries = Util.parseConfigIdListAttribute(objid, 'serverEntries', "ServerIndex");
        entryFound = 0;
        for serverEntry in serverEntries:
          if len(serverEntry) > 0:
            serverName = Util.getOptionalAttribute(serverEntry, 'serverName', "ServerEntry");
            if (serverName == objectName):
              ServerEntry.update(serverEntry, curjsonobject);
              entryFound=1;
              break;
        if (entryFound == 0):
           Log.debug("Unable to locate ServerEntry for %s" % objectName);

  Util.popPathElement('ServerIndex');
