#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(parentrespath, name, defaultParent, rdnProperties):
  Util.pushPathElement('SupportedEntityType');
  
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSupportedEntityType");
  exportedObject.put("roleName", "WebSphereSupportedEntityType");

  roleProperties = JSONObject();

  Util.addToJsonIfNotNone(roleProperties, "entityType", name);
  Util.addToJsonIfNotNone(roleProperties, "baseEntry", defaultParent);
  Util.addToJsonIfNotNone(roleProperties, "rdnProperties", rdnProperties);

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SupportedEntityType');
  return result;

def update(jsonobject):
  Util.pushPathElement('SupportedEntityType');
  if not jsonobject.has("roleProperties"):
    raise Exception("SupportedEntityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  name = roleProperties.optString("entityType", None);
  defaultParent = roleProperties.optString("baseEntry", None);
  rdnProperties = roleProperties.optString("rdnProperties", None);
  rdnProperties = rdnProperties.replace(", ",";");
  # need to clear out rdnProperties, then add them
  updateIdMgrSupportedEntityTypeParams = "[-name " + name + " -defaultParent " + defaultParent + " -rdnProperties ]";
  Log.debug("Running command to add federated repository attribute mapping: AdminTask.setIdMgrRealmURAttrMapping(" + updateIdMgrSupportedEntityTypeParams + ")");
  Util.updateIdMgrSupportedEntityType(updateIdMgrSupportedEntityTypeParams);
  updateIdMgrSupportedEntityTypeParams = "[-name " + name + " -defaultParent " + defaultParent + " -rdnProperties " + rdnProperties + "]";
  Log.debug("Running command to add federated repository attribute mapping: AdminTask.setIdMgrRealmURAttrMapping(" + updateIdMgrSupportedEntityTypeParams + ")");
  Util.updateIdMgrSupportedEntityType(updateIdMgrSupportedEntityTypeParams);
  Util.popPathElement('SupportedEntityType');

