from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASHandler')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASHandler");
  exportedObject.put("roleName", "WebSphereWASHandler");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.washandler.handlername", objid, "handlerName","WASHandler");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.washandler.portnames", objid, "portNames","WASHandler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.washandler.handlerclass", objid, "handlerClass","WASHandler");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.washandler.soaproles", objid, "soapRoles","WASHandler");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASHandler');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASHandler')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASHandler resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "handlerName", roleProperties.optString("websphere.washandler.handlername", None));
  Util.addPathProperty(properties, "portNames", roleProperties.optString("websphere.washandler.portnames", None));
  Util.addIfNotNone(properties, "handlerClass", roleProperties.optString("websphere.washandler.handlerclass", None));
  Util.addPathProperty(properties, "soapRoles", roleProperties.optString("websphere.washandler.soaproles", None));
  print "Creating WASHandler with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASHandler", parentid, properties);
  Util.popPathElement('WASHandler');

def update(objid,jsonobject):
  Util.pushPathElement('WASHandler')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASHandler resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.washandler.handlername", None), "handlerName","WASHandler");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.washandler.portnames", None), "portNames","WASHandler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.washandler.handlerclass", None), "handlerClass","WASHandler");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.washandler.soaproles", None), "soapRoles","WASHandler");
  if len(atts) != 0:
    print "Modifying WASHandler with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASHandler configuration up to date.";

  Util.popPathElement('WASHandler');
