from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASResourceRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASResourceRef");
  exportedObject.put("roleName", "WebSphereWASResourceRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceref.lookupname", objid, "lookupName","WASResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceref.auth", objid, "auth","WASResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceref.refname", objid, "refName","WASResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceref.type", objid, "type","WASResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceref.link", objid, "link","WASResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceref.ressharingscope", objid, "resSharingScope","WASResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceref.mappedname", objid, "mappedName","WASResourceRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASResourceRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASResourceRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.wasresourceref.lookupname", None));
  Util.addIfNotNone(properties, "auth", roleProperties.optString("websphere.wasresourceref.auth", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.wasresourceref.refname", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.wasresourceref.type", None));
  Util.addIfNotNone(properties, "link", roleProperties.optString("websphere.wasresourceref.link", None));
  Util.addIfNotNone(properties, "resSharingScope", roleProperties.optString("websphere.wasresourceref.ressharingscope", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.wasresourceref.mappedname", None));
  print "Creating WASResourceRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASResourceRef", parentid, properties);
  Util.popPathElement('WASResourceRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASResourceRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceref.lookupname", None), "lookupName","WASResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceref.auth", None), "auth","WASResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceref.refname", None), "refName","WASResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceref.type", None), "type","WASResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceref.link", None), "link","WASResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceref.ressharingscope", None), "resSharingScope","WASResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceref.mappedname", None), "mappedName","WASResourceRef");
  if len(atts) != 0:
    print "Modifying WASResourceRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASResourceRef configuration up to date.";

  Util.popPathElement('WASResourceRef');
