from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.eventinfrastructureprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'EventInfrastructureProvider');

  containmentpath = "%(parentconpath)sEventInfrastructureProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('EventInfrastructureProvider')

  name = Util.getRequiredAttribute(objid, "name", 'EventInfrastructureProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEventInfrastructureProvider");
  exportedObject.put("roleName", "WebSphereEventInfrastructureProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.eventinfrastructureprovider.classpath", objid, "classpath","EventInfrastructureProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventinfrastructureprovider.name", objid, "name","EventInfrastructureProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventinfrastructureprovider.isolatedclassloader", objid, "isolatedClassLoader","EventInfrastructureProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.eventinfrastructureprovider.nativepath", objid, "nativepath","EventInfrastructureProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventinfrastructureprovider.description", objid, "description","EventInfrastructureProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventinfrastructureprovider.providertype", objid, "providerType","EventInfrastructureProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EventInfrastructureProvider');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  #This configuration object was removed in WebSphere 9 so we cannot import it to that version.
  #This scenario may occur if we are importing configuration data from an earlier version of WebSphere (ie, WebSphere 7).
  if not Util.isValidType("EventInfrastructureProvider", 1):
    return None;

  if not jsonobject.has("roleProperties"):
    raise Exception("EventInfrastructureProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.eventinfrastructureprovider.name"):
    raise Exception("Resource role properties does not contain websphere.eventinfrastructureprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create EventInfrastructureProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  if not Util.isValidType("EventInfrastructureProvider", 1):
    return None;
  Util.pushPathElement('EventInfrastructureProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventInfrastructureProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventinfrastructureprovider.name"):
    raise Exception("Resource role properties does not contain websphere.eventinfrastructureprovider.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.eventinfrastructureprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.eventinfrastructureprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.eventinfrastructureprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.eventinfrastructureprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.eventinfrastructureprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.eventinfrastructureprovider.providertype", None));
  print "Creating EventInfrastructureProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EventInfrastructureProvider", parentid, properties);
  Util.popPathElement('EventInfrastructureProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('EventInfrastructureProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventInfrastructureProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventinfrastructureprovider.name"):
    raise Exception("Resource role properties does not contain websphere.eventinfrastructureprovider.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.eventinfrastructureprovider.classpath", None), "classpath","EventInfrastructureProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventinfrastructureprovider.name", None), "name","EventInfrastructureProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventinfrastructureprovider.isolatedclassloader", None), "isolatedClassLoader","EventInfrastructureProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.eventinfrastructureprovider.nativepath", None), "nativepath","EventInfrastructureProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventinfrastructureprovider.description", None), "description","EventInfrastructureProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventinfrastructureprovider.providertype", None), "providerType","EventInfrastructureProvider");
  if len(atts) != 0:
    print "Modifying EventInfrastructureProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EventInfrastructureProvider configuration up to date.";

  Util.popPathElement('EventInfrastructureProvider');
