from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HealthTime')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHealthTime");
  exportedObject.put("roleName", "WebSphereHealthTime");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthtime.hour", objid, "hour","HealthTime");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthtime.minute", objid, "minute","HealthTime");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HealthTime');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('HealthTime')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthTime resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "hour", roleProperties.optString("websphere.healthtime.hour", None));
  Util.addIfNotNone(properties, "minute", roleProperties.optString("websphere.healthtime.minute", None));
  print "Creating HealthTime with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HealthTime", parentid, properties, attName);
  Util.popPathElement('HealthTime');

def update(objid,jsonobject):
  Util.pushPathElement('HealthTime')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthTime resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthtime.hour", None), "hour","HealthTime");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthtime.minute", None), "minute","HealthTime");
  if len(atts) != 0:
    print "Modifying HealthTime with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HealthTime configuration up to date.";

  Util.popPathElement('HealthTime');
