#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from InjectionTarget import InjectionTarget

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ResourceEnvRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereResourceEnvRef");
  exportedObject.put("roleName", "WebSphereResourceEnvRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceenvref.name", objid, "name","ResourceEnvRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceenvref.mappedname", objid, "mappedName","ResourceEnvRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceenvref.lookupname", objid, "lookupName","ResourceEnvRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceenvref.description", objid, "description","ResourceEnvRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ResourceEnvRef');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'ResourceEnvRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      returndict = Util.createTypeFolder(respath, "InjectionTarget", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      injName = Util.getOptionalAttribute(injTarget, "injectionTargetName", "InjectionTarget");
      if injName is not None and len(injName) > 0:
        resourceName = injName;
      else:
        resourceName = "InjectionTarget%s" % i;
      Util.addAllFromExport(extraObjects, InjectionTarget._export(injTarget, currespath, resourceName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ResourceEnvRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ResourceEnvRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResourceEnvRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.resourceenvref.name", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.resourceenvref.mappedname", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.resourceenvref.lookupname", ""));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.resourceenvref.description", None));
  print "Creating ResourceEnvRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ResourceEnvRef", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('ResourceEnvRef');

def update(objid,jsonobject):
  Util.pushPathElement('ResourceEnvRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResourceEnvRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceenvref.name", None), "name","ResourceEnvRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceenvref.mappedname", None), "mappedName","ResourceEnvRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceenvref.lookupname", ""), "lookupName","ResourceEnvRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceenvref.description", None), "description","ResourceEnvRef");
  if len(atts) != 0:
    print "Modifying ResourceEnvRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ResourceEnvRef configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ResourceEnvRef');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'ResourceEnvRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      Util.remove(injTarget);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('ResourceEnvRef');
