from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthIdentityAdopter import SIBAuthIdentityAdopter;
from SIBAuthSender import SIBAuthSender;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthForeignDestination')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthForeignDestination");
  exportedObject.put("roleName", "WebSphereSIBAuthForeignDestination");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthforeigndestination.busname", objid, "busName","SIBAuthForeignDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthforeigndestination.destinationname", objid, "destinationName","SIBAuthForeignDestination");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthForeignDestination');
  if identityAdopter is not None and len(identityAdopter) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthIdentityAdopter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthIdentityAdopter._export(identityAdopter, currespath, "SIBAuthIdentityAdopter"));

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthForeignDestination');
  if sender is not None and len(sender) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthSender", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthSender._export(sender, currespath, "SIBAuthSender"));


  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthForeignDestination');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthForeignDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibauthforeigndestination.busname", None));
  Util.addIfNotNone(properties, "destinationName", roleProperties.optString("websphere.sibauthforeigndestination.destinationname", None));
  print "Creating SIBAuthForeignDestination with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthForeignDestination", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthForeignDestination');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthForeignDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthforeigndestination.busname", None), "busName","SIBAuthForeignDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthforeigndestination.destinationname", None), "destinationName","SIBAuthForeignDestination");
  if len(atts) != 0:
    print "Modifying SIBAuthForeignDestination with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthForeignDestination configuration up to date.";

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthForeignDestination');
  if identityAdopter is not None and len(identityAdopter) > 0:
    Util.remove(identityAdopter);

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthForeignDestination');
  if sender is not None and len(sender) > 0:
    Util.remove(sender);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthForeignDestination');
