from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBTopicSpaceMapEntry')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBTopicSpaceMapEntry");
  exportedObject.put("roleName", "WebSphereSIBTopicSpaceMapEntry");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacemapentry.localtopicspace", objid, "localTopicSpace","SIBTopicSpaceMapEntry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacemapentry.remotetopicspace", objid, "remoteTopicSpace","SIBTopicSpaceMapEntry");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBTopicSpaceMapEntry');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBTopicSpaceMapEntry')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceMapEntry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "localTopicSpace", roleProperties.optString("websphere.sibtopicspacemapentry.localtopicspace", None));
  Util.addIfNotNone(properties, "remoteTopicSpace", roleProperties.optString("websphere.sibtopicspacemapentry.remotetopicspace", None));
  print "Creating SIBTopicSpaceMapEntry with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBTopicSpaceMapEntry", parentid, properties);
  Util.popPathElement('SIBTopicSpaceMapEntry');

def update(objid,jsonobject):
  Util.pushPathElement('SIBTopicSpaceMapEntry')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceMapEntry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacemapentry.localtopicspace", None), "localTopicSpace","SIBTopicSpaceMapEntry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacemapentry.remotetopicspace", None), "remoteTopicSpace","SIBTopicSpaceMapEntry");
  if len(atts) != 0:
    print "Modifying SIBTopicSpaceMapEntry with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBTopicSpaceMapEntry configuration up to date.";

  Util.popPathElement('SIBTopicSpaceMapEntry');
