from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.schedulerconfiguration.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'SchedulerConfiguration');

  containmentpath = "%(parentconpath)sSchedulerConfiguration:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('SchedulerConfiguration')

  name = Util.getRequiredAttribute(objid, "name", 'SchedulerConfiguration');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSchedulerConfiguration");
  exportedObject.put("roleName", "WebSphereSchedulerConfiguration");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.securityrole", objid, "securityRole","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.tableprefix", objid, "tablePrefix","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.name", objid, "name","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.pollinterval", objid, "pollInterval","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.category", objid, "category","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.datasourcejndiname", objid, "datasourceJNDIName","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.loginconfigname", objid, "loginConfigName","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.providertype", objid, "providerType","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.workmanagerinfojndiname", objid, "workManagerInfoJNDIName","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.useadminroles", objid, "useAdminRoles","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.jndiname", objid, "jndiName","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.datasourcealias", objid, "datasourceAlias","SchedulerConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerconfiguration.description", objid, "description","SchedulerConfiguration");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SchedulerConfiguration');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("SchedulerConfiguration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.schedulerconfiguration.name"):
    raise Exception("Resource role properties does not contain websphere.schedulerconfiguration.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create SchedulerConfiguration on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('SchedulerConfiguration')
  if not jsonobject.has("roleProperties"):
    raise Exception("SchedulerConfiguration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.schedulerconfiguration.name"):
    raise Exception("Resource role properties does not contain websphere.schedulerconfiguration.name!");

  properties = [];
  Util.addIfNotNone(properties, "securityRole", roleProperties.optString("websphere.schedulerconfiguration.securityrole", None));
  Util.addIfNotNone(properties, "tablePrefix", roleProperties.optString("websphere.schedulerconfiguration.tableprefix", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.schedulerconfiguration.name", None));
  Util.addIfNotNone(properties, "pollInterval", roleProperties.optString("websphere.schedulerconfiguration.pollinterval", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.schedulerconfiguration.category", None));
  Util.addIfNotNone(properties, "datasourceJNDIName", roleProperties.optString("websphere.schedulerconfiguration.datasourcejndiname", None));
  Util.addIfNotNone(properties, "loginConfigName", roleProperties.optString("websphere.schedulerconfiguration.loginconfigname", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.schedulerconfiguration.providertype", None));
  Util.addIfNotNone(properties, "workManagerInfoJNDIName", roleProperties.optString("websphere.schedulerconfiguration.workmanagerinfojndiname", None));
  Util.addIfNotNone(properties, "useAdminRoles", roleProperties.optString("websphere.schedulerconfiguration.useadminroles", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.schedulerconfiguration.jndiname", None));
  Util.addIfNotNone(properties, "datasourceAlias", roleProperties.optString("websphere.schedulerconfiguration.datasourcealias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.schedulerconfiguration.description", None));
  print "Creating SchedulerConfiguration with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SchedulerConfiguration", parentid, properties);
  Util.popPathElement('SchedulerConfiguration');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SchedulerConfiguration')
  if not jsonobject.has("roleProperties"):
    raise Exception("SchedulerConfiguration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.schedulerconfiguration.name"):
    raise Exception("Resource role properties does not contain websphere.schedulerconfiguration.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.securityrole", None), "securityRole","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.tableprefix", None), "tablePrefix","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.name", None), "name","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.pollinterval", None), "pollInterval","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.category", None), "category","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.datasourcejndiname", None), "datasourceJNDIName","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.loginconfigname", None), "loginConfigName","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.providertype", None), "providerType","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.workmanagerinfojndiname", None), "workManagerInfoJNDIName","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.useadminroles", None), "useAdminRoles","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.jndiname", None), "jndiName","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.datasourcealias", None), "datasourceAlias","SchedulerConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerconfiguration.description", None), "description","SchedulerConfiguration");
  if len(atts) != 0:
    print "Modifying SchedulerConfiguration with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SchedulerConfiguration configuration up to date.";

  Util.popPathElement('SchedulerConfiguration');
