from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.timermanagerprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'TimerManagerProvider');

  containmentpath = "%(parentconpath)sTimerManagerProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('TimerManagerProvider')

  name = Util.getRequiredAttribute(objid, "name", 'TimerManagerProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTimerManagerProvider");
  exportedObject.put("roleName", "WebSphereTimerManagerProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.timermanagerprovider.classpath", objid, "classpath","TimerManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerprovider.name", objid, "name","TimerManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerprovider.isolatedclassloader", objid, "isolatedClassLoader","TimerManagerProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.timermanagerprovider.nativepath", objid, "nativepath","TimerManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerprovider.description", objid, "description","TimerManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerprovider.providertype", objid, "providerType","TimerManagerProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TimerManagerProvider');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("TimerManagerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.timermanagerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.timermanagerprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create TimerManagerProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('TimerManagerProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("TimerManagerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.timermanagerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.timermanagerprovider.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.timermanagerprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.timermanagerprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.timermanagerprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.timermanagerprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.timermanagerprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.timermanagerprovider.providertype", None));
  print "Creating TimerManagerProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TimerManagerProvider", parentid, properties);
  Util.popPathElement('TimerManagerProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('TimerManagerProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("TimerManagerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.timermanagerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.timermanagerprovider.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerprovider.classpath", None), "classpath","TimerManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerprovider.name", None), "name","TimerManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerprovider.isolatedclassloader", None), "isolatedClassLoader","TimerManagerProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerprovider.nativepath", None), "nativepath","TimerManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerprovider.description", None), "description","TimerManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerprovider.providertype", None), "providerType","TimerManagerProvider");
  if len(atts) != 0:
    print "Modifying TimerManagerProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TimerManagerProvider configuration up to date.";

  Util.popPathElement('TimerManagerProvider');
