from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from JFAPFactory import JFAPFactory
from TCPFactory import TCPFactory
from GenericChannelFactory import GenericChannelFactory
from RMQChannelFactory import RMQChannelFactory
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TransportChannelFactory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransportChannelFactory");
  exportedObject.put("roleName", "WebSphereTransportChannelFactory");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"TransportChannelFactory");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TransportChannelFactory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TransportChannelFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportChannelFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating TransportChannelFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TransportChannelFactory", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TransportChannelFactory');

def update(objid,jsonobject):
  Util.pushPathElement('TransportChannelFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportChannelFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying TransportChannelFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TransportChannelFactory configuration up to date.";

  Property.removeProperties(objid, 'properties',"TransportChannelFactory");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
  Util.popPathElement('TransportChannelFactory');

def removeTransportChannelFactories(objid, attributeName, parentType):
  factories = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if factories is not None and len(factories) > 0:
    for factory in factories:
      if len(factory) > 0:
        Util.remove(factory);

def exportTransportChannelFactories(objid, respath, extraObjects, typeFolders, attributeName, parentType):
  counterTransportChannelFactory = 0;
  counterJFAPFactory = 0;
  counterTCPFactory = 0;
  counterGenericChannelFactory = 0;
  counterRMQChannelFactory = 0;

  factories = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if factories is not None and len(factories) > 0:
    for factory in factories:
      if len(factory) > 0:
        if factory.find("#TransportChannelFactory_") != -1:
          returndict = Util.createTypeFolder(respath, "TransportChannelFactory", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, _export(factory, currespath, 'TransportChannelFactory%s' % counterTransportChannelFactory));
          counterTransportChannelFactory = counterTransportChannelFactory + 1;
        elif factory.find("#JFAPFactory_") != -1:
          returndict = Util.createTypeFolder(respath, "JFAPFactory", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, JFAPFactory._export(factory, currespath, 'JFAPFactory%s' % counterJFAPFactory));
          counterJFAPFactory = counterJFAPFactory + 1;
        elif factory.find("#TCPFactory_") != -1:
          returndict = Util.createTypeFolder(respath, "TCPFactory", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, TCPFactory._export(factory, currespath, 'TCPFactory%s' % counterTCPFactory));
          counterTCPFactory = counterTCPFactory + 1;
        elif factory.find("#GenericChannelFactory_") != -1:
          returndict = Util.createTypeFolder(respath, "GenericChannelFactory", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, GenericChannelFactory._export(factory, currespath, 'GenericChannelFactory%s' % counterGenericChannelFactory));
          counterGenericChannelFactory = counterGenericChannelFactory + 1;
        elif factory.find("#RMQChannelFactory_") != -1:
          returndict = Util.createTypeFolder(respath, "RMQChannelFactory", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, RMQChannelFactory._export(factory, currespath, 'RMQChannelFactory%s' % counterRMQChannelFactory));
          counterRMQChannelFactory = counterRMQChannelFactory + 1;

  return extraObjects;

def createObjIfRole(objid, curjsonobject, currole):
  if currole == "WebSphereTransportChannelFactory":
    create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereJFAPFactory":
    JFAPFactory.create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereTCPFactory":
    TCPFactory.create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereGenericChannelFactory":
    GenericChannelFactory.create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereRMQChannelFactory":
    RMQChannelFactory.create(objid, curjsonobject);
    return 1;
  return 0;

