from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSNServicePoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSNServicePoint");
  exportedObject.put("roleName", "WebSphereWSNServicePoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.subscriptionmanagerportname", objid, "subscriptionManagerPortName","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.addedbusmember", objid, "addedBusMember","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.jaxwshandlerlistnb", objid, "jaxwsHandlerListNB","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.notificationbrokerportname", objid, "notificationBrokerPortName","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.connectedepltobus", objid, "connectedEPLToBus","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.installedwebspheretargetid", objid, "installedWebSphereTargetID","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.servicepointapplicationreference", objid, "servicePointApplicationReference","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.transporturlroot", objid, "transportURLRoot","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.pubregmanagerportname", objid, "pubRegManagerPortName","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.description", objid, "description","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.uuid", objid, "uuid","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.createdepl", objid, "createdEPL","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.jaxwshandlerlistsm", objid, "jaxwsHandlerListSM","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.soapversion", objid, "soapVersion","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.jaxwshandlerlistprm", objid, "jaxwsHandlerListPRM","WSNServicePoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservicepoint.name", objid, "name","WSNServicePoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"WSNServicePoint");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSNServicePoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSNServicePoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNServicePoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "subscriptionManagerPortName", roleProperties.optString("websphere.wsnservicepoint.subscriptionmanagerportname", None));
  Util.addIfNotNone(properties, "addedBusMember", roleProperties.optString("websphere.wsnservicepoint.addedbusmember", None));
  Util.addIfNotNone(properties, "jaxwsHandlerListNB", roleProperties.optString("websphere.wsnservicepoint.jaxwshandlerlistnb", None));
  Util.addIfNotNone(properties, "notificationBrokerPortName", roleProperties.optString("websphere.wsnservicepoint.notificationbrokerportname", None));
  Util.addIfNotNone(properties, "connectedEPLToBus", roleProperties.optString("websphere.wsnservicepoint.connectedepltobus", None));
  Util.addIfNotNone(properties, "installedWebSphereTargetID", roleProperties.optString("websphere.wsnservicepoint.installedwebspheretargetid", None));
  Util.addIfNotNone(properties, "servicePointApplicationReference", roleProperties.optString("websphere.wsnservicepoint.servicepointapplicationreference", None));
  Util.addIfNotNone(properties, "transportURLRoot", roleProperties.optString("websphere.wsnservicepoint.transporturlroot", None));
  Util.addIfNotNone(properties, "pubRegManagerPortName", roleProperties.optString("websphere.wsnservicepoint.pubregmanagerportname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wsnservicepoint.description", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.wsnservicepoint.uuid", None));
  Util.addIfNotNone(properties, "createdEPL", roleProperties.optString("websphere.wsnservicepoint.createdepl", None));
  Util.addIfNotNone(properties, "jaxwsHandlerListSM", roleProperties.optString("websphere.wsnservicepoint.jaxwshandlerlistsm", None));
  Util.addIfNotNone(properties, "soapVersion", roleProperties.optString("websphere.wsnservicepoint.soapversion", None));
  Util.addIfNotNone(properties, "jaxwsHandlerListPRM", roleProperties.optString("websphere.wsnservicepoint.jaxwshandlerlistprm", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsnservicepoint.name", None));
  print "Creating WSNServicePoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSNServicePoint", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNServicePoint');

def update(objid,jsonobject):
  Util.pushPathElement('WSNServicePoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNServicePoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.subscriptionmanagerportname", None), "subscriptionManagerPortName","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.addedbusmember", None), "addedBusMember","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.jaxwshandlerlistnb", None), "jaxwsHandlerListNB","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.notificationbrokerportname", None), "notificationBrokerPortName","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.connectedepltobus", None), "connectedEPLToBus","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.installedwebspheretargetid", None), "installedWebSphereTargetID","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.servicepointapplicationreference", None), "servicePointApplicationReference","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.transporturlroot", None), "transportURLRoot","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.pubregmanagerportname", None), "pubRegManagerPortName","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.description", None), "description","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.uuid", None), "uuid","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.createdepl", None), "createdEPL","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.jaxwshandlerlistsm", None), "jaxwsHandlerListSM","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.soapversion", None), "soapVersion","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.jaxwshandlerlistprm", None), "jaxwsHandlerListPRM","WSNServicePoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservicepoint.name", None), "name","WSNServicePoint");
  if len(atts) != 0:
    print "Modifying WSNServicePoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSNServicePoint configuration up to date.";

  Property.removeProperties(objid, 'property',"WSNServicePoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNServicePoint');
