from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WorkClassModule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkClassModule");
  exportedObject.put("roleName", "WebSphereWorkClassModule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workclassmodule.matchexpression", objid, "matchExpression","WorkClassModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workclassmodule.modulename", objid, "moduleName","WorkClassModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workclassmodule.id", objid, "id","WorkClassModule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkClassModule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WorkClassModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkClassModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "matchExpression", roleProperties.optString("websphere.workclassmodule.matchexpression", None));
  Util.addIfNotNone(properties, "moduleName", roleProperties.optString("websphere.workclassmodule.modulename", None));
  Util.addIfNotNone(properties, "id", roleProperties.optString("websphere.workclassmodule.id", None));
  print "Creating WorkClassModule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkClassModule", parentid, properties);
  Util.popPathElement('WorkClassModule');

def update(objid,jsonobject):
  Util.pushPathElement('WorkClassModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkClassModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workclassmodule.matchexpression", None), "matchExpression","WorkClassModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workclassmodule.modulename", None), "moduleName","WorkClassModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workclassmodule.id", None), "id","WorkClassModule");
  if len(atts) != 0:
    print "Modifying WorkClassModule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkClassModule configuration up to date.";

  Util.popPathElement('WorkClassModule');
