from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DynamicWtCtrlr')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDynamicWtCtrlr");
  exportedObject.put("roleName", "WebSphereDynamicWtCtrlr");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicwtctrlr.enabled", objid, "enabled","DynamicWtCtrlr");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'Property',"DynamicWtCtrlr");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DynamicWtCtrlr');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DynamicWtCtrlr')
  if not jsonobject.has("roleProperties"):
    raise Exception("DynamicWtCtrlr resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.dynamicwtctrlr.enabled", None));
  print "Creating DynamicWtCtrlr with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DynamicWtCtrlr", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DynamicWtCtrlr');

def update(objid,jsonobject):
  Util.pushPathElement('DynamicWtCtrlr')
  if not jsonobject.has("roleProperties"):
    raise Exception("DynamicWtCtrlr resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicwtctrlr.enabled", None), "enabled","DynamicWtCtrlr");
  if len(atts) != 0:
    print "Modifying DynamicWtCtrlr with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DynamicWtCtrlr configuration up to date.";

  Property.removeProperties(objid, 'Property',"DynamicWtCtrlr");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('DynamicWtCtrlr');
