from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Container')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereContainer");
  exportedObject.put("roleName", "WebSphereContainer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.container.directoryentry", objid, "directoryEntry","Container");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.container.uri", objid, "URI","Container");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.container.size", objid, "size","Container");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.container.lastmodified", objid, "lastModified","Container");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.container.originaluri", objid, "originalURI","Container");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "Container");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Container');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Container')
  if not jsonobject.has("roleProperties"):
    raise Exception("Container resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.container.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.container.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.container.size", None));
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.container.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.container.originaluri", None));
  print "Creating Container with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Container", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Container');

def update(objid,jsonobject):
  Util.pushPathElement('Container')
  if not jsonobject.has("roleProperties"):
    raise Exception("Container resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.container.directoryentry", None), "directoryEntry","Container");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.container.uri", None), "URI","Container");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.container.size", None), "size","Container");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.container.lastmodified", None), "lastModified","Container");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.container.originaluri", None), "originalURI","Container");
  if len(atts) != 0:
    print "Modifying Container with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Container configuration up to date.";

  File.removeFiles(objid, 'files',"Container");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Container');
