from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DRSSettings import DRSSettings

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EJBModuleConfiguration')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEJBModuleConfiguration");
  exportedObject.put("roleName", "WebSphereEJBModuleConfiguration");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduleconfiguration.name", objid, "name","EJBModuleConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduleconfiguration.description", objid, "description","EJBModuleConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduleconfiguration.enablesfsbfailover", objid, "enableSFSBFailover","EJBModuleConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduleconfiguration.overridedefaultdrssettings", objid, "overrideDefaultDRSSettings","EJBModuleConfiguration");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  
  typeFolders = {};  
  drsSettings = Util.getOptionalAttribute(objid, 'drsSettings',"EJBModuleConfiguration");
  if drsSettings is not None and len(drsSettings) > 0:
    returndict = Util.createTypeFolder(respath, "DRSSettings", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, DRSSettings._export(drsSettings, currespath, "DRSSettings"));  
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EJBModuleConfiguration');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EJBModuleConfiguration')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBModuleConfiguration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.ejbmoduleconfiguration.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.ejbmoduleconfiguration.description", None));
  Util.addIfNotNone(properties, "enableSFSBFailover", roleProperties.optString("websphere.ejbmoduleconfiguration.enablesfsbfailover", None));
  Util.addIfNotNone(properties, "overrideDefaultDRSSettings", roleProperties.optString("websphere.ejbmoduleconfiguration.overridedefaultdrssettings", None));
  print "Creating EJBModuleConfiguration with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EJBModuleConfiguration", parentid, properties);
  
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereDRSSettings":
        DRSSettings.create(objid, curjsonobject);
  Util.popPathElement('EJBModuleConfiguration');

  return objid;        
   

def update(objid,jsonobject):
  Util.pushPathElement('EJBModuleConfiguration')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBModuleConfiguration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduleconfiguration.name", None), "name","EJBModuleConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduleconfiguration.description", None), "description","EJBModuleConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduleconfiguration.enablesfsbfailover", None), "enableSFSBFailover","EJBModuleConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduleconfiguration.overridedefaultdrssettings", None), "overrideDefaultDRSSettings","EJBModuleConfiguration");
  if len(atts) != 0:
    print "Modifying EJBModuleConfiguration with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EJBModuleConfiguration configuration up to date.";

  drsSettings = Util.getOptionalAttribute(objid, 'drsSettings',"EJBModuleConfiguration");
  if drsSettings is not None and len(drsSettings) > 0:
    Util.remove(drsSettings);
    
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereDRSSettings":
        DRSSettings.create(objid, curjsonobject);           

  Util.popPathElement('EJBModuleConfiguration');
