from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('FileTransferService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereFileTransferService");
  exportedObject.put("roleName", "WebSphereFileTransferService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filetransferservice.retriescount", objid, "retriesCount","FileTransferService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filetransferservice.enable", objid, "enable","FileTransferService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filetransferservice.retrywaittime", objid, "retryWaitTime","FileTransferService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"FileTransferService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('FileTransferService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('FileTransferService')
  if not jsonobject.has("roleProperties"):
    raise Exception("FileTransferService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "retriesCount", roleProperties.optString("websphere.filetransferservice.retriescount", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.filetransferservice.enable", None));
  Util.addIfNotNone(properties, "retryWaitTime", roleProperties.optString("websphere.filetransferservice.retrywaittime", None));
  print "Creating FileTransferService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("FileTransferService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('FileTransferService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('FileTransferService')
  if not jsonobject.has("roleProperties"):
    raise Exception("FileTransferService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filetransferservice.retriescount", None), "retriesCount","FileTransferService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filetransferservice.enable", None), "enable","FileTransferService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filetransferservice.retrywaittime", None), "retryWaitTime","FileTransferService");
  if len(atts) != 0:
    print "Modifying FileTransferService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "FileTransferService configuration up to date.";

  Property.removeProperties(objid,'properties',"FileTransferService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('FileTransferService');
