from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.library.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'Library');

  containmentpath = "%(parentconpath)sLibrary:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('Library')

  name = Util.getRequiredAttribute(objid, "name", 'Library');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLibrary");
  exportedObject.put("roleName", "WebSphereLibrary");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.library.nativepath", objid, "nativePath","Library");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.library.name", objid, "name","Library");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.library.isolatedclassloader", objid, "isolatedClassLoader","Library");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.library.description", objid, "description","Library");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.library.classpath", objid, "classPath","Library");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Library');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("Library resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.library.name"):
    raise Exception("Resource role properties does not contain websphere.library.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create Library on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('Library')
  if not jsonobject.has("roleProperties"):
    raise Exception("Library resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.library.name"):
    raise Exception("Resource role properties does not contain websphere.library.name!");

  properties = [];
  Util.addPathProperty(properties, "nativePath", roleProperties.optString("websphere.library.nativepath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.library.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.library.isolatedclassloader", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.library.description", None));
  Util.addPathProperty(properties, "classPath", roleProperties.optString("websphere.library.classpath", None));
  print "Creating Library with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Library", parentid, properties);
  Util.popPathElement('Library');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('Library')
  if not jsonobject.has("roleProperties"):
    raise Exception("Library resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.library.name"):
    raise Exception("Resource role properties does not contain websphere.library.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.library.nativepath", None), "nativePath","Library");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.library.name", None), "name","Library");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.library.isolatedclassloader", None), "isolatedClassLoader","Library");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.library.description", None), "description","Library");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.library.classpath", None), "classPath","Library");
  if len(atts) != 0:
    print "Modifying Library with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Library configuration up to date.";

  Util.popPathElement('Library');
