from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PME51ServerExtension')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePME51ServerExtension");
  exportedObject.put("roleName", "WebSpherePME51ServerExtension");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PME51ServerExtension');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PME51ServerExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PME51ServerExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating PME51ServerExtension with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PME51ServerExtension", parentid, properties);
  Util.popPathElement('PME51ServerExtension');

def update(objid,jsonobject):
  Util.pushPathElement('PME51ServerExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PME51ServerExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying PME51ServerExtension with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PME51ServerExtension configuration up to date.";

  Util.popPathElement('PME51ServerExtension');
