from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBTopicSpaceLocalizationPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBTopicSpaceLocalizationPoint");
  exportedObject.put("roleName", "WebSphereSIBTopicSpaceLocalizationPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacelocalizationpoint.identifier", objid, "identifier","SIBTopicSpaceLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacelocalizationpoint.highmessagethreshold", objid, "highMessageThreshold","SIBTopicSpaceLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacelocalizationpoint.uuid", objid, "uuid","SIBTopicSpaceLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacelocalizationpoint.targetuuid", objid, "targetUuid","SIBTopicSpaceLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacelocalizationpoint.sendallowed", objid, "sendAllowed","SIBTopicSpaceLocalizationPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBTopicSpaceLocalizationPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBTopicSpaceLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibtopicspacelocalizationpoint.identifier", None));
  Util.addIfNotNone(properties, "highMessageThreshold", roleProperties.optString("websphere.sibtopicspacelocalizationpoint.highmessagethreshold", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibtopicspacelocalizationpoint.uuid", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibtopicspacelocalizationpoint.targetuuid", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibtopicspacelocalizationpoint.sendallowed", None));
  print "Creating SIBTopicSpaceLocalizationPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBTopicSpaceLocalizationPoint", parentid, properties);
  Util.popPathElement('SIBTopicSpaceLocalizationPoint');

def update(objid,jsonobject):
  Util.pushPathElement('SIBTopicSpaceLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacelocalizationpoint.identifier", None), "identifier","SIBTopicSpaceLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacelocalizationpoint.highmessagethreshold", None), "highMessageThreshold","SIBTopicSpaceLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacelocalizationpoint.uuid", None), "uuid","SIBTopicSpaceLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacelocalizationpoint.targetuuid", None), "targetUuid","SIBTopicSpaceLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacelocalizationpoint.sendallowed", None), "sendAllowed","SIBTopicSpaceLocalizationPoint");
  if len(atts) != 0:
    print "Modifying SIBTopicSpaceLocalizationPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBTopicSpaceLocalizationPoint configuration up to date.";

  Util.popPathElement('SIBTopicSpaceLocalizationPoint');
