from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from TaskProvider import TaskProvider
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationManagementService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationManagementService");
  exportedObject.put("roleName", "WebSphereApplicationManagementService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationmanagementservice.enable", objid, "enable","ApplicationManagementService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationmanagementservice.enablebinarydistribution", objid, "enableBinaryDistribution","ApplicationManagementService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ApplicationManagementService");

  i = 0;
  taskProviders = Util.parseConfigIdListAttribute(objid, 'taskProviders',"ApplicationManagementService");
  for taskProvider in taskProviders:
    if len(taskProvider) > 0:
      returndict = Util.createTypeFolder(respath, "TaskProvider", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, TaskProvider._export(taskProvider, currespath, "TaskProvider%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationManagementService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ApplicationManagementService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationManagementService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.applicationmanagementservice.enable", None));
  Util.addIfNotNone(properties, "enableBinaryDistribution", roleProperties.optString("websphere.applicationmanagementservice.enablebinarydistribution", None));
  print "Creating ApplicationManagementService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationManagementService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereCoreTaskProvider":
          TaskProvider.create(objid, curjsonobject);
  Util.popPathElement('ApplicationManagementService');


def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ApplicationManagementService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationManagementService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationmanagementservice.enable", None), "enable","ApplicationManagementService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationmanagementservice.enablebinarydistribution", None), "enableBinaryDistribution","ApplicationManagementService");
  if len(atts) != 0:
    print "Modifying ApplicationManagementService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationManagementService configuration up to date.";

  Property.removeProperties(objid, 'properties',"ApplicationManagementService");

  taskProviders = Util.parseConfigIdListAttribute(objid, 'taskProviders',"ApplicationManagementService");
  for taskProvider in taskProviders:
    if len(taskProvider) > 0:
      Util.remove(taskProvider);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereCoreTaskProvider":
          TaskProvider.create(objid, curjsonobject);
  Util.popPathElement('ApplicationManagementService');
