from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LocalOSUserRegistry')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLocalOSUserRegistry");
  exportedObject.put("roleName", "WebSphereLocalOSUserRegistry");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.useregistryrealm", objid, "useRegistryRealm","LocalOSUserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.serverpassword", objid, "serverPassword","LocalOSUserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.primaryadminid", objid, "primaryAdminId","LocalOSUserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.useregistryserverid", objid, "useRegistryServerId","LocalOSUserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.limit", objid, "limit","LocalOSUserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.serverid", objid, "serverId","LocalOSUserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.realm", objid, "realm","LocalOSUserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.localosuserregistry.ignorecase", objid, "ignoreCase","LocalOSUserRegistry");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"LocalOSUserRegistry");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LocalOSUserRegistry');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  return doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):

  localOSUserReg = Util.getid(containmentpath);

  if localOSUserReg == None or localOSUserReg == "":
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      localOSUserReg = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(localOSUserReg);
      localOSUserReg = None;
    else:
      update(localOSUserReg, jsonobject);
  return localOSUserReg;

def create(parentid, jsonobject):
  Util.pushPathElement('LocalOSUserRegistry')
  if not jsonobject.has("roleProperties"):
    raise Exception("LocalOSUserRegistry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "useRegistryRealm", roleProperties.optString("websphere.localosuserregistry.useregistryrealm", None));
  Util.addIfNotNone(properties, "serverPassword", roleProperties.optString("websphere.localosuserregistry.serverpassword", None));
  Util.addIfNotNone(properties, "primaryAdminId", roleProperties.optString("websphere.localosuserregistry.primaryadminid", None));
  Util.addIfNotNone(properties, "useRegistryServerId", roleProperties.optString("websphere.localosuserregistry.useregistryserverid", None));
  Util.addIfNotNone(properties, "limit", roleProperties.optString("websphere.localosuserregistry.limit", None));
  Util.addIfNotNone(properties, "serverId", roleProperties.optString("websphere.localosuserregistry.serverid", None));
  Util.addIfNotNone(properties, "realm", roleProperties.optString("websphere.localosuserregistry.realm", None));
  Util.addIfNotNone(properties, "ignoreCase", roleProperties.optString("websphere.localosuserregistry.ignorecase", None));
  print "Creating LocalOSUserRegistry with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LocalOSUserRegistry", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LocalOSUserRegistry');

def update(parentid,jsonobject):
  Util.pushPathElement('LocalOSUserRegistry')
  objid = getLocalOSUserRegistry(parentid)[0];

  if not jsonobject.has("roleProperties"):
    raise Exception("LocalOSUserRegistry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.useregistryrealm", None), "useRegistryRealm","LocalOSUserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.serverpassword", None), "serverPassword","LocalOSUserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.primaryadminid", None), "primaryAdminId","LocalOSUserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.useregistryserverid", None), "useRegistryServerId","LocalOSUserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.limit", None), "limit","LocalOSUserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.serverid", None), "serverId","LocalOSUserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.realm", None), "realm","LocalOSUserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.localosuserregistry.ignorecase", None), "ignoreCase","LocalOSUserRegistry");
  if len(atts) != 0:
    print "Modifying LocalOSUserRegistry with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LocalOSUserRegistry configuration up to date.";

  Property.removeProperties(objid, 'properties',"LocalOSUserRegistry");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LocalOSUserRegistry');

def getLocalOSUserRegistry(objid):
  localOSUserRegistry = Util.getAssociatedObjects(objid, "LocalOSUserRegistry");
  return localOSUserRegistry;
