from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ORBInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'ORBInboundChannel');
  
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereORBInboundChannel");
  exportedObject.put("roleName", "WebSphereORBInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.orbinboundchannel.name", objid, "name","ORBInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.orbinboundchannel.discriminationweight", objid, "discriminationWeight","ORBInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ORBInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ORBInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ORBInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("ORBInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.orbinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.orbinboundchannel.discriminationweight", None));
  print "Creating ORBInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ORBInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ORBInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ORBInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("ORBInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.orbinboundchannel.name", None), "name","ORBInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.orbinboundchannel.discriminationweight", None), "discriminationWeight","ORBInboundChannel");
  if len(atts) != 0:
    print "Modifying ORBInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ORBInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"ORBInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ORBInboundChannel');
