from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBQueueLocalizationPoint import SIBQueueLocalizationPoint
from SIBTopicSpaceLocalizationPoint import SIBTopicSpaceLocalizationPoint
from SIBMediationLocalizationPoint import SIBMediationLocalizationPoint
from SIBMQLinkSenderChannelLocalizationPoint import SIBMQLinkSenderChannelLocalizationPoint

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBLocalizationPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBLocalizationPoint");
  exportedObject.put("roleName", "WebSphereSIBLocalizationPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpoint.identifier", objid, "identifier","SIBLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpoint.highmessagethreshold", objid, "highMessageThreshold","SIBLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpoint.uuid", objid, "uuid","SIBLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpoint.targetuuid", objid, "targetUuid","SIBLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpoint.sendallowed", objid, "sendAllowed","SIBLocalizationPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBLocalizationPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.siblocalizationpoint.identifier", None));
  Util.addIfNotNone(properties, "highMessageThreshold", roleProperties.optString("websphere.siblocalizationpoint.highmessagethreshold", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.siblocalizationpoint.uuid", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.siblocalizationpoint.targetuuid", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.siblocalizationpoint.sendallowed", None));
  print "Creating SIBLocalizationPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBLocalizationPoint", parentid, properties);
  Util.popPathElement('SIBLocalizationPoint');

def update(objid,jsonobject):
  Util.pushPathElement('SIBLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpoint.identifier", None), "identifier","SIBLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpoint.highmessagethreshold", None), "highMessageThreshold","SIBLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpoint.uuid", None), "uuid","SIBLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpoint.targetuuid", None), "targetUuid","SIBLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpoint.sendallowed", None), "sendAllowed","SIBLocalizationPoint");
  if len(atts) != 0:
    print "Modifying SIBLocalizationPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBLocalizationPoint configuration up to date.";
  Util.popPathElement('SIBLocalizationPoint');

def removeLocalizationPoints(objid, attributeName, parentType):
  localizationPoints = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if localizationPoints is not None and len(localizationPoints) > 0:
    for localizationPoint in localizationPoints:
      if len(localizationPoint) > 0:
        Util.remove(localizationPoint);

def exportLocalizationPoints(objid, respath, extraObjects, typeFolders, attributeName, parentType):
  counterSIBLocalizationPoint = 0;
  counterSIBQueueLocalizationPoint = 0;
  counterSIBTopicSpaceLocalizationPoint = 0;
  counterSIBMediationLocalizationPoint = 0;
  counterSIBMQLinkSenderChannelLocalizationPoint = 0;

  localizationPoints = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if localizationPoints is not None and len(localizationPoints) > 0:
    for localizationPoint in localizationPoints:
      if len(localizationPoint) > 0:
        if localizationPoint.find("#SIBLocalizationPoint_") != -1:
          returndict = Util.createTypeFolder(respath, "SIBLocalizationPoint", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, _export(localizationPoint, currespath, 'SIBLocalizationPoint%s' % counterSIBLocalizationPoint));
          counterSIBLocalizationPoint = counterSIBLocalizationPoint + 1;
        elif localizationPoint.find("#SIBQueueLocalizationPoint_") != -1:
          returndict = Util.createTypeFolder(respath, "SIBQueueLocalizationPoint", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIBQueueLocalizationPoint._export(localizationPoint, currespath, 'SIBQueueLocalizationPoint%s' % counterSIBQueueLocalizationPoint));
          counterSIBQueueLocalizationPoint = counterSIBQueueLocalizationPoint + 1;
        elif localizationPoint.find("#SIBTopicSpaceLocalizationPoint_") != -1:
          returndict = Util.createTypeFolder(respath, "SIBTopicSpaceLocalizationPoint", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIBTopicSpaceLocalizationPoint._export(localizationPoint, currespath, 'SIBTopicSpaceLocalizationPoint%s' % counterSIBTopicSpaceLocalizationPoint));
          counterSIBTopicSpaceLocalizationPoint = counterSIBTopicSpaceLocalizationPoint + 1;
        elif localizationPoint.find("#SIBMediationLocalizationPoint_") != -1:
          returndict = Util.createTypeFolder(respath, "SIBMediationLocalizationPoint", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIBMediationLocalizationPoint._export(localizationPoint, currespath, 'SIBMediationLocalizationPoint%s' % counterSIBMediationLocalizationPoint));
          counterSIBMediationLocalizationPoint = counterSIBMediationLocalizationPoint + 1;
        elif localizationPoint.find("#SIBMQLinkSenderChannelLocalizationPoint_") != -1:
          returndict = Util.createTypeFolder(respath, "SIBMQLinkSenderChannelLocalizationPoint", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIBMQLinkSenderChannelLocalizationPoint._export(localizationPoint, currespath, 'SIBMQLinkSenderChannelLocalizationPoint%s' % counterSIBMQLinkSenderChannelLocalizationPoint));
          counterSIBMQLinkSenderChannelLocalizationPoint = counterSIBMQLinkSenderChannelLocalizationPoint + 1;

  return extraObjects;

def createObjIfRole(objid, curjsonobject, currole):
  if currole == "WebSphereSIBLocalizationPoint":
    create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereSIBQueueLocalizationPoint":
    SIBQueueLocalizationPoint.create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereSIBTopicSpaceLocalizationPoint":
    SIBTopicSpaceLocalizationPoint.create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereSIBMediationLocalizationPoint":
    SIBMediationLocalizationPoint.create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereSIBMQLinkSenderChannelLocalizationPoint":
    SIBMQLinkSenderChannelLocalizationPoint.create(objid, curjsonobject);
    return 1;

  return 0;
