from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBusMemberTarget import SIBusMemberTarget

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBusMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBusMember");
  exportedObject.put("roleName", "WebSphereSIBusMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmember.cluster", objid, "cluster","SIBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmember.node", objid, "node","SIBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmember.description", objid, "description","SIBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmember.server", objid, "server","SIBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmember.policyname", objid, "policyName","SIBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmember.assistanceenabled", objid, "assistanceEnabled","SIBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmember.mqserver", objid, "mqServer","SIBusMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  siBusMemberTargets = Util.parseConfigIdListAttribute(objid, 'target',"SIBusMember");
  for siBusMemberTarget in siBusMemberTargets:
    if len(siBusMemberTarget) > 0:
      returndict = Util.createTypeFolder(respath, "SIBusMemberTarget", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBusMemberTarget._export(siBusMemberTarget, currespath, "SIBus Member Target%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBusMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBusMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBusMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cluster", roleProperties.optString("websphere.sibusmember.cluster", None));
  Util.addIfNotNone(properties, "node", roleProperties.optString("websphere.sibusmember.node", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibusmember.description", None));
  Util.addIfNotNone(properties, "server", roleProperties.optString("websphere.sibusmember.server", None));
  Util.addIfNotNone(properties, "policyName", roleProperties.optString("websphere.sibusmember.policyname", None));
  Util.addIfNotNone(properties, "assistanceEnabled", roleProperties.optString("websphere.sibusmember.assistanceenabled", None));
  Util.addIfNotNone(properties, "mqServer", roleProperties.optString("websphere.sibusmember.mqserver", None));
  print "Creating SIBusMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBusMember", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBusMemberTarget":
        SIBusMemberTarget.create(objid, curjsonobject);
  Util.popPathElement('SIBusMember');

def update(objid,jsonobject):
  Util.pushPathElement('SIBusMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBusMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmember.cluster", None), "cluster","SIBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmember.node", None), "node","SIBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmember.description", None), "description","SIBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmember.server", None), "server","SIBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmember.policyname", None), "policyName","SIBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmember.assistanceenabled", None), "assistanceEnabled","SIBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmember.mqserver", None), "mqServer","SIBusMember");
  if len(atts) != 0:
    print "Modifying SIBusMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBusMember configuration up to date.";

  siBusMemberTargets = Util.parseConfigIdListAttribute(objid, 'target',"SIBusMember");
  for siBusMemberTarget in siBusMemberTargets:
    if len(siBusMemberTarget) > 0:
      Util.remove(siBusMemberTarget);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBusMemberTarget":
        SIBusMemberTarget.create(objid, curjsonobject);

  Util.popPathElement('SIBusMember');
