from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASPersistenceUnitRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASPersistenceUnitRef");
  exportedObject.put("roleName", "WebSphereWASPersistenceUnitRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.waspersistenceunitref.mappedname", objid, "mappedName","WASPersistenceUnitRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.waspersistenceunitref.persistenceunitname", objid, "persistenceUnitName","WASPersistenceUnitRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.waspersistenceunitref.refname", objid, "refName","WASPersistenceUnitRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASPersistenceUnitRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASPersistenceUnitRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASPersistenceUnitRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.waspersistenceunitref.mappedname", None));
  Util.addIfNotNone(properties, "persistenceUnitName", roleProperties.optString("websphere.waspersistenceunitref.persistenceunitname", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.waspersistenceunitref.refname", None));
  print "Creating WASPersistenceUnitRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASPersistenceUnitRef", parentid, properties);
  Util.popPathElement('WASPersistenceUnitRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASPersistenceUnitRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASPersistenceUnitRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.waspersistenceunitref.mappedname", None), "mappedName","WASPersistenceUnitRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.waspersistenceunitref.persistenceunitname", None), "persistenceUnitName","WASPersistenceUnitRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.waspersistenceunitref.refname", None), "refName","WASPersistenceUnitRef");
  if len(atts) != 0:
    print "Modifying WASPersistenceUnitRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASPersistenceUnitRef configuration up to date.";

  Util.popPathElement('WASPersistenceUnitRef');
