from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DeploymentTargetMapping import DeploymentTargetMapping
from Property import Property
from Classloader import Classloader

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ConnectorModuleDeployment')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConnectorModuleDeployment");
  exportedObject.put("roleName", "WebSphereConnectorModuleDeployment");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectormoduledeployment.name", objid, "name","ConnectorModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectormoduledeployment.startingweight", objid, "startingWeight","ConnectorModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectormoduledeployment.uri", objid, "uri","ConnectorModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectormoduledeployment.deploymentid", objid, "deploymentId","ConnectorModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectormoduledeployment.altdd", objid, "altDD","ConnectorModuleDeployment");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ConnectorModuleDeployment");
  i = 0;
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"ConnectorModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      returndict = Util.createTypeFolder(respath, "DeploymentTargetMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DeploymentTargetMapping._export(targetmapping, currespath, "DeploymentTargetMapping%s" % i));
      i = i + 1;
      
  classloader = Util.getRequiredAttribute(objid, 'classloader',"ConnectorModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    returndict = Util.createTypeFolder(respath, "Classloader", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, Classloader._export(classloader, currespath, "Classloader"));
    
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ConnectorModuleDeployment');
  return result;

def create(parentid, jsonobject):
  Util.pushPathElement('ConnectorModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectorModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.connectormoduledeployment.name", ""));
  Util.addIfNotNone(properties, "startingWeight", roleProperties.optString("websphere.connectormoduledeployment.startingweight", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.connectormoduledeployment.uri", None));
  Util.addIfNotNone(properties, "deploymentId", roleProperties.optString("websphere.connectormoduledeployment.deploymentid", None));
  Util.addIfNotNone(properties, "altDD", roleProperties.optString("websphere.connectormoduledeployment.altdd", None));
  print "Creating ConnectorModuleDeployment with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ConnectorModuleDeployment", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);      
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ConnectorModuleDeployment');

def update(objid,jsonobject):
  Util.pushPathElement('ConnectorModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectorModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectormoduledeployment.name", ""), "name","ConnectorModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectormoduledeployment.startingweight", None), "startingWeight","ConnectorModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectormoduledeployment.uri", None), "uri","ConnectorModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectormoduledeployment.deploymentid", None), "deploymentId","ConnectorModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectormoduledeployment.altdd", None), "altDD","ConnectorModuleDeployment");
  if len(atts) != 0:
    print "Modifying ConnectorModuleDeployment with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ConnectorModuleDeployment configuration up to date.";

  Property.removeProperties(objid, 'properties',"ConnectorModuleDeployment");
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"ConnectorModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      Util.remove(targetmapping);
      
  classloader = Util.getRequiredAttribute(objid, 'classloader',"ConnectorModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    Util.remove(classloader);  

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);            
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ConnectorModuleDeployment');
