from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from MappingModule import MappingModule;
from ConnectionTest import ConnectionTest;
from J2EEResourcePropertySet import J2EEResourcePropertySet;
from ConnectionPool import ConnectionPool
from CMPConnectorFactory import CMPConnectorFactory
from Property import Property

__name_att__ = "websphere.datasource.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'DataSource');

  containmentpath = "%(parentconpath)sDataSource:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('DataSource')

  name = Util.getRequiredAttribute(objid, "name", 'DataSource');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDataSource");
  exportedObject.put("roleName", "WebSphereDataSource");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.statementcachesize", objid, "statementCacheSize","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.logmissingtransactioncontext", objid, "logMissingTransactionContext","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.datasourcehelperclassname", objid, "datasourceHelperClassname","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.authmechanismpreference", objid, "authMechanismPreference","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.providertype", objid, "providerType","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.authdataalias", objid, "authDataAlias","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.jndiname", objid, "jndiName","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.managecachedhandles", objid, "manageCachedHandles","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.category", objid, "category","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.xarecoveryauthalias", objid, "xaRecoveryAuthAlias","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.description", objid, "description","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.diagnoseconnectionusage", objid, "diagnoseConnectionUsage","DataSource");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasource.name", objid, "name","DataSource");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DataSource");
  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'DataSource');
  if connPool is not None and len(connPool) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionPool._export(connPool, currespath, 'ConnectionPool'));

  respropset = Util.getOptionalAttribute(objid, 'propertySet', 'DataSource');
  if respropset is not None and len(respropset) > 0:
    returndict = Util.createTypeFolder(respath, "J2EEResourcePropertySet", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, J2EEResourcePropertySet._export(respropset, currespath, 'J2EEResourcePropertySet'));

  mapmod = Util.getOptionalAttribute(objid, 'mapping', 'DataSource');
  if mapmod is not None and len(mapmod) > 0:
    returndict = Util.createTypeFolder(respath, "MappingModule", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, MappingModule._export(mapmod, currespath, 'MappingModule'));

  conntest = Util.getOptionalAttribute(objid, 'preTestConfig', 'DataSource');
  if conntest is not None and len(conntest) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionTest", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionTest._export(conntest, currespath, 'ConnectionTest'));

  cmp = getCMP(objid, name)
  if cmp is not None and len(cmp) > 0:
    returndict = Util.createTypeFolder(respath, "CMPConnectorFactory", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, CMPConnectorFactory._export(cmp, currespath));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DataSource');
  return result;



def _doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("DataSource resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.datasource.name"):
    raise Exception("Resource role properties does not contain websphere.datasource.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create DataSource on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('DataSource')
  if not jsonobject.has("roleProperties"):
    raise Exception("DataSource resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.datasource.name"):
    raise Exception("Resource role properties does not contain websphere.datasource.name!");

  dsName = roleProperties.getString("websphere.datasource.name");

  properties = [];
  Util.addIfNotNone(properties, "statementCacheSize", roleProperties.optString("websphere.datasource.statementcachesize", None));
  Util.addIfNotNone(properties, "logMissingTransactionContext", roleProperties.optString("websphere.datasource.logmissingtransactioncontext", None));
  Util.addIfNotNone(properties, "datasourceHelperClassname", roleProperties.optString("websphere.datasource.datasourcehelperclassname", None));
  Util.addIfNotNone(properties, "authMechanismPreference", roleProperties.optString("websphere.datasource.authmechanismpreference", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.datasource.providertype", None));
  Util.addIfNotNone(properties, "authDataAlias", roleProperties.optString("websphere.datasource.authdataalias", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.datasource.jndiname", None));
  Util.addIfNotNone(properties, "manageCachedHandles", roleProperties.optString("websphere.datasource.managecachedhandles", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.datasource.category", None));
  Util.addIfNotNone(properties, "xaRecoveryAuthAlias", roleProperties.optString("websphere.datasource.xarecoveryauthalias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.datasource.description", None));
  Util.addIfNotNone(properties, "diagnoseConnectionUsage", roleProperties.optString("websphere.datasource.diagnoseconnectionusage", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.datasource.name", None));
  print "Creating DataSource with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DataSource", parentid, properties);

  Property.removeProperties(objid, 'properties',"DataSource");

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'DataSource');
  if connPool is not None and len(connPool) > 0:
    Util.remove(connPool);

  conntest = Util.getOptionalAttribute(objid, 'preTestConfig', 'DataSource');
  if conntest is not None and len(conntest) > 0:
    Util.remove(conntest);

  mapmod = Util.getOptionalAttribute(objid, 'mapping', 'DataSource');
  if mapmod is not None and len(mapmod) > 0:
    Util.remove(mapmod);

  propset = Util.getOptionalAttribute(objid, 'propertySet', 'DataSource');
  if propset is not None and len(propset) > 0:
    Util.remove(propset);

  cmp = getCMP(objid, dsName);
  if cmp is not None and len(cmp) > 0:
    Util.remove(cmp);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if currole == "WebSphereConnectionPool":
        ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereConnectionTest":
        ConnectionTest.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      elif currole == "WebSphereJ2EEResourcePropertySet":
        J2EEResourcePropertySet.create(objid, curjsonobject);
      elif currole == "WebSphereCMPConnectorFactory":
        # CMPConnectorFactory name is in the format DataSourceName_CF
        dsName = roleProperties.optString("websphere.datasource.name", None);
        cmpName = dsName + "_CF";
        # CMPConnectorFactory objects are created on a J2CResourceAdapter object named
        # WebSphere Relational Resource Adapter
        wrra = getWRRAforCMP(objid, cmpName);
        CMPConnectorFactory.create(wrra, curjsonobject);
  Util.popPathElement('DataSource');

  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('DataSource')
  if not jsonobject.has("roleProperties"):
    raise Exception("DataSource resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.datasource.name"):
    raise Exception("Resource role properties does not contain websphere.datasource.name!");

  dsName = roleProperties.getString("websphere.datasource.name");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.statementcachesize", None), "statementCacheSize","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.logmissingtransactioncontext", None), "logMissingTransactionContext","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.datasourcehelperclassname", None), "datasourceHelperClassname","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.authmechanismpreference", None), "authMechanismPreference","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.providertype", None), "providerType","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.authdataalias", None), "authDataAlias","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.jndiname", None), "jndiName","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.managecachedhandles", None), "manageCachedHandles","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.category", None), "category","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.xarecoveryauthalias", None), "xaRecoveryAuthAlias","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.description", None), "description","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.diagnoseconnectionusage", None), "diagnoseConnectionUsage","DataSource");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasource.name", None), "name","DataSource");
  if len(atts) != 0:
    print "Modifying DataSource with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "DataSource configuration up to date.";

  cmp = getCMP(objid, dsName);
  if cmp is not None and len(cmp) > 0:
    Util.remove(cmp);

  Property.removeProperties(objid, 'properties',"DataSource");

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'DataSource');
  if connPool is not None and len(connPool) > 0:
    Util.remove(connPool);

  conntest = Util.getOptionalAttribute(objid, 'preTestConfig', 'DataSource');
  if conntest is not None and len(conntest) > 0:
    Util.remove(conntest);

  mapmod = Util.getOptionalAttribute(objid, 'mapping', 'DataSource');
  if mapmod is not None and len(mapmod) > 0:
    Util.remove(mapmod);

  propset = Util.getOptionalAttribute(objid, 'propertySet', 'DataSource');
  if propset is not None and len(propset) > 0:
    Util.remove(propset);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if currole == "WebSphereConnectionPool":
        ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereConnectionTest":
        ConnectionTest.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      elif currole == "WebSphereJ2EEResourcePropertySet":
        J2EEResourcePropertySet.create(objid, curjsonobject);
      elif currole == "WebSphereCMPConnectorFactory":
        # CMPConnectorFactory name is in the format DataSourceName_CF
        cmpName = dsName + "_CF";
        # CMPConnectorFactory objects are created on a J2CResourceAdapter object named
        # WebSphere Relational Resource Adapter
        wrra = getWRRAforCMP(objid, cmpName)
        CMPConnectorFactory.create(wrra, curjsonobject);

  Util.popPathElement('DataSource');

# find the correct WebSphere Relational Resource Adapter J2CResourceAdapter obect to
# create a CMPConnectorFactory object on
def getWRRAforCMP(objid, cmpName):

  wrraToUse = None;
  scope = Util.getScope(objid);

  # get all WebSphere Relational Resource Adapter J2CResourceAdapter objects
  wrras = Util.getid("/J2CResourceAdapter:WebSphere Relational Resource Adapter/").splitlines();
  if len(wrras) > 0:
    for wrra in wrras:
      if len(wrra) > 0:
        # see if this WRRA id contains the same scope as the DataSource
        wrraScope = Util.getScope(wrra);
        if scope == wrraScope:
          wrraToUse = wrra;
          break;
  if wrraToUse is None:
    raise Exception("Could not find the WebSphere Relational Resource Adapter J2CResourceAdapter to create a container managed persistence (CMP) on.");
  return wrraToUse;

def getCMP(objid, name):
  scope = Util.getScope(objid);
  # name of the CMP is in the format DataSourceName_CF
  targetName = name + "_CF"
  # get all CMPConnectorFactory objects
  cmpConnectorFactories = Util.getid("/CMPConnectorFactory:/").splitlines();
  cmpId = None;
  if len(cmpConnectorFactories) > 0:
    for cmpConnectorFactory in cmpConnectorFactories:
      if len(cmpConnectorFactory) > 0:
        # see if this CMPConncetorFactory id contains the same scope as the DataSource
        cmpScope = Util.getScope(cmpConnectorFactory);
        if scope == cmpScope:
          # next, we need to verify the object names match
          foundName = Util.getOptionalAttribute(cmpConnectorFactory, "name", "CMPConnectorFactory");
          if foundName == targetName:
            cmpId = cmpConnectorFactory;
            break;
  return cmpId;

def getDataSources(objid):
  dataSources = Util.getAssociatedObjects(objid, "DataSource");
  return dataSources;
