from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LibraryRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLibraryRef");
  exportedObject.put("roleName", "WebSphereLibraryRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.libraryref.libraryname", objid, "libraryName","LibraryRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.libraryref.sharedclassloader", objid, "sharedClassloader","LibraryRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LibraryRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LibraryRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("LibraryRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "libraryName", roleProperties.optString("websphere.libraryref.libraryname", None));
  Util.addIfNotNone(properties, "sharedClassloader", roleProperties.optString("websphere.libraryref.sharedclassloader", None));
  print "Creating LibraryRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LibraryRef", parentid, properties);
  Util.popPathElement('LibraryRef');

def update(objid,jsonobject):
  Util.pushPathElement('LibraryRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("LibraryRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.libraryref.libraryname", None), "libraryName","LibraryRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.libraryref.sharedclassloader", None), "sharedClassloader","LibraryRef");
  if len(atts) != 0:
    print "Modifying LibraryRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LibraryRef configuration up to date.";

  Util.popPathElement('LibraryRef');
