from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.middlewareapp.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MiddlewareApp');

  containmentpath = "%(parentconpath)sMiddlewareApp:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MiddlewareApp')

  name = Util.getRequiredAttribute(objid, "name", 'MiddlewareApp');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMiddlewareApp");
  exportedObject.put("roleName", "WebSphereMiddlewareApp");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareapp.name", objid, "name","MiddlewareApp");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareapp.type", objid, "type","MiddlewareApp");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MiddlewareApp");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MiddlewareApp');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareApp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.middlewareapp.name"):
    raise Exception("Resource role properties does not contain websphere.middlewareapp.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MiddlewareApp on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MiddlewareApp')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareApp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.middlewareapp.name"):
    raise Exception("Resource role properties does not contain websphere.middlewareapp.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.middlewareapp.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.middlewareapp.type", None));
  print "Creating MiddlewareApp with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MiddlewareApp", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('MiddlewareApp');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MiddlewareApp')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareApp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.middlewareapp.name"):
    raise Exception("Resource role properties does not contain websphere.middlewareapp.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareapp.name", None), "name","MiddlewareApp");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareapp.type", None), "type","MiddlewareApp");
  if len(atts) != 0:
    print "Modifying MiddlewareApp with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MiddlewareApp configuration up to date.";

  Property.removeProperties(objid, 'properties',"MiddlewareApp");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('MiddlewareApp');
