from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = "", gatherProperties = 1):
  Util.pushPathElement('OverlayEndpoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereOverlayEndpoint");
  exportedObject.put("roleName", "WebSphereOverlayEndpoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.overlayendpoint.port", objid, "port","OverlayEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.overlayendpoint.host", objid, "host","OverlayEndpoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if gatherProperties == 1:
    extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"OverlayEndpoint");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('OverlayEndpoint');
  return result;



def create(parentid, jsonobject, attribute = ""):
  Util.pushPathElement('OverlayEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("OverlayEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.overlayendpoint.port", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.overlayendpoint.host", None));
  print "Creating OverlayEndpoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("OverlayEndpoint", parentid, properties, attribute);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('OverlayEndpoint');


def update(objid,jsonobject):
  Util.pushPathElement('OverlayEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("OverlayEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.overlayendpoint.port", None), "port","OverlayEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.overlayendpoint.host", None), "host","OverlayEndpoint");
  if len(atts) != 0:
    print "Modifying OverlayEndpoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "OverlayEndpoint configuration up to date.";

  Property.removeProperties(objid, 'properties',"OverlayEndpoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('OverlayEndpoint');
