from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CAClient')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCAClient");
  exportedObject.put("roleName", "WebSphereCAClient");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.name", objid, "name","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.basedn", objid, "baseDn","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.port", objid, "port","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.pkiclientimplclass", objid, "pkiClientImplClass","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.userid", objid, "userId","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.retrycheck", objid, "retryCheck","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.frequencycheck", objid, "frequencyCheck","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.password", objid, "password","CAClient");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.caclient.host", objid, "host","CAClient");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"CAClient");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CAClient');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CAClient')
  if not jsonobject.has("roleProperties"):
    raise Exception("CAClient resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.caclient.name", None));
  Util.addIfNotNone(properties, "baseDn", roleProperties.optString("websphere.caclient.basedn", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.caclient.port", None));
  Util.addIfNotNone(properties, "pkiClientImplClass", roleProperties.optString("websphere.caclient.pkiclientimplclass", None));
  Util.addIfNotNone(properties, "userId", roleProperties.optString("websphere.caclient.userid", None));
  Util.addIfNotNone(properties, "retryCheck", roleProperties.optString("websphere.caclient.retrycheck", None));
  Util.addIfNotNone(properties, "frequencyCheck", roleProperties.optString("websphere.caclient.frequencycheck", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.caclient.password", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.caclient.host", None));
  print "Creating CAClient with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CAClient", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CAClient');


def update(objid,jsonobject):
  Util.pushPathElement('CAClient')
  if not jsonobject.has("roleProperties"):
    raise Exception("CAClient resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.name", None), "name","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.basedn", None), "baseDn","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.port", None), "port","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.pkiclientimplclass", None), "pkiClientImplClass","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.userid", None), "userId","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.retrycheck", None), "retryCheck","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.frequencycheck", None), "frequencyCheck","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.password", None), "password","CAClient");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.caclient.host", None), "host","CAClient");
  if len(atts) != 0:
    print "Modifying CAClient with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CAClient configuration up to date.";

  Property.removeProperties(objid, 'properties',"CAClient");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CAClient');
