from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CryptoHardwareToken')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCryptoHardwareToken");
  exportedObject.put("roleName", "WebSphereCryptoHardwareToken");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cryptohardwaretoken.password", objid, "password","CryptoHardwareToken");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cryptohardwaretoken.libraryfile", objid, "libraryFile","CryptoHardwareToken");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cryptohardwaretoken.tokentype", objid, "tokenType","CryptoHardwareToken");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CryptoHardwareToken');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CryptoHardwareToken')
  if not jsonobject.has("roleProperties"):
    raise Exception("CryptoHardwareToken resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.cryptohardwaretoken.password", None));
  Util.addIfNotNone(properties, "libraryFile", roleProperties.optString("websphere.cryptohardwaretoken.libraryfile", None));
  Util.addIfNotNone(properties, "tokenType", roleProperties.optString("websphere.cryptohardwaretoken.tokentype", None));
  print "Creating CryptoHardwareToken with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CryptoHardwareToken", parentid, properties);
  Util.popPathElement('CryptoHardwareToken');

def update(objid,jsonobject):
  Util.pushPathElement('CryptoHardwareToken')
  if not jsonobject.has("roleProperties"):
    raise Exception("CryptoHardwareToken resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cryptohardwaretoken.password", None), "password","CryptoHardwareToken");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cryptohardwaretoken.libraryfile", None), "libraryFile","CryptoHardwareToken");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cryptohardwaretoken.tokentype", None), "tokenType","CryptoHardwareToken");
  if len(atts) != 0:
    print "Modifying CryptoHardwareToken with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CryptoHardwareToken configuration up to date.";

  Util.popPathElement('CryptoHardwareToken');
