from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DisplayDescriptor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDisplayDescriptor");
  exportedObject.put("roleName", "WebSphereDisplayDescriptor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.displaydescriptor.hoverhelpkey", objid, "hoverHelpKey","DisplayDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.displaydescriptor.displaynamekey", objid, "displayNameKey","DisplayDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.displaydescriptor.displaydescriptionkey", objid, "displayDescriptionKey","DisplayDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.displaydescriptor.readonly", objid, "readonly","DisplayDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.displaydescriptor.firstclass", objid, "firstClass","DisplayDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.displaydescriptor.weight", objid, "weight","DisplayDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.displaydescriptor.hidden", objid, "hidden","DisplayDescriptor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DisplayDescriptor");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DisplayDescriptor');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DisplayDescriptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("DisplayDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "hoverHelpKey", roleProperties.optString("websphere.displaydescriptor.hoverhelpkey", None));
  Util.addIfNotNone(properties, "displayNameKey", roleProperties.optString("websphere.displaydescriptor.displaynamekey", None));
  Util.addIfNotNone(properties, "displayDescriptionKey", roleProperties.optString("websphere.displaydescriptor.displaydescriptionkey", None));
  Util.addIfNotNone(properties, "readonly", roleProperties.optString("websphere.displaydescriptor.readonly", None));
  Util.addIfNotNone(properties, "firstClass", roleProperties.optString("websphere.displaydescriptor.firstclass", None));
  Util.addIfNotNone(properties, "weight", roleProperties.optString("websphere.displaydescriptor.weight", None));
  Util.addIfNotNone(properties, "hidden", roleProperties.optString("websphere.displaydescriptor.hidden", None));
  print "Creating DisplayDescriptor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DisplayDescriptor", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DisplayDescriptor');

def update(objid,jsonobject):
  Util.pushPathElement('DisplayDescriptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("DisplayDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.displaydescriptor.hoverhelpkey", None), "hoverHelpKey","DisplayDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.displaydescriptor.displaynamekey", None), "displayNameKey","DisplayDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.displaydescriptor.displaydescriptionkey", None), "displayDescriptionKey","DisplayDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.displaydescriptor.readonly", None), "readonly","DisplayDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.displaydescriptor.firstclass", None), "firstClass","DisplayDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.displaydescriptor.weight", None), "weight","DisplayDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.displaydescriptor.hidden", None), "hidden","DisplayDescriptor");
  if len(atts) != 0:
    print "Modifying DisplayDescriptor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DisplayDescriptor configuration up to date.";

  Property.removeProperties(objid, 'properties',"DisplayDescriptor");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('DisplayDescriptor');
