from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ElasticityAction import ElasticityAction
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ElasticityType')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereElasticityType");
  exportedObject.put("roleName", "WebSphereElasticityType");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.elasticitytype.type", objid, "type","ElasticityType");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = ElasticityAction.exportElasticityActions(objid, respath, extraObjects, typeFolders, 'actions',"ElasticityType");

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ElasticityType');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ElasticityType')
  if not jsonobject.has("roleProperties"):
    raise Exception("ElasticityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.elasticitytype.type", None));
  print "Creating ElasticityType with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ElasticityType", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      ElasticityAction.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ElasticityType');

def update(objid,jsonobject):
  Util.pushPathElement('ElasticityType')
  if not jsonobject.has("roleProperties"):
    raise Exception("ElasticityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.elasticitytype.type", None), "type","ElasticityType");
  if len(atts) != 0:
    print "Modifying ElasticityType with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ElasticityType configuration up to date.";

  ElasticityAction.removeElasticityActions(objid, 'actions',"ElasticityType");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      ElasticityAction.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('ElasticityType');
