from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('InstancePool')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereInstancePool");
  exportedObject.put("roleName", "WebSphereInstancePool");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.instancepool.minsize", objid, "minSize","InstancePool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.instancepool.maxsize", objid, "maxSize","InstancePool");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('InstancePool');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('InstancePool')
  if not jsonobject.has("roleProperties"):
    raise Exception("InstancePool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "minSize", roleProperties.optString("websphere.instancepool.minsize", None));
  Util.addIfNotNone(properties, "maxSize", roleProperties.optString("websphere.instancepool.maxsize", None));
  print "Creating InstancePool with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("InstancePool", parentid, properties);
  Util.popPathElement('InstancePool');

def update(objid,jsonobject):
  Util.pushPathElement('InstancePool')
  if not jsonobject.has("roleProperties"):
    raise Exception("InstancePool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.instancepool.minsize", None), "minSize","InstancePool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.instancepool.maxsize", None), "maxSize","InstancePool");
  if len(atts) != 0:
    print "Modifying InstancePool with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "InstancePool configuration up to date.";

  Util.popPathElement('InstancePool');
