from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RewritingRule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRewritingRule");
  exportedObject.put("roleName", "WebSphereRewritingRule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rewritingrule.fromurlpattern", objid, "fromURLPattern","RewritingRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rewritingrule.tourlpattern", objid, "toURLPattern","RewritingRule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"RewritingRule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RewritingRule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RewritingRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("RewritingRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "fromURLPattern", roleProperties.optString("websphere.rewritingrule.fromurlpattern", None));
  Util.addIfNotNone(properties, "toURLPattern", roleProperties.optString("websphere.rewritingrule.tourlpattern", None));
  print "Creating RewritingRule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RewritingRule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RewritingRule');

def update(objid,jsonobject):
  Util.pushPathElement('RewritingRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("RewritingRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rewritingrule.fromurlpattern", None), "fromURLPattern","RewritingRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rewritingrule.tourlpattern", None), "toURLPattern","RewritingRule");
  if len(atts) != 0:
    print "Modifying RewritingRule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RewritingRule configuration up to date.";

  Property.removeProperties(objid, 'properties',"RewritingRule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RewritingRule');
