from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthBrowser import SIBAuthBrowser;
from SIBAuthCreator import SIBAuthCreator;
from SIBAuthIdentityAdopter import SIBAuthIdentityAdopter;
from SIBAuthReceiver import SIBAuthReceiver;
from SIBAuthSender import SIBAuthSender;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthQueue')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthQueue");
  exportedObject.put("roleName", "WebSphereSIBAuthQueue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthqueue.inheritdefaults", objid, "inheritDefaults","SIBAuthQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthqueue.identifier", objid, "identifier","SIBAuthQueue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  browser = Util.getOptionalAttribute(objid, 'browser', 'SIBAuthQueue');
  if browser is not None and len(browser) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthBrowser", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthBrowser._export(browser, currespath, "SIBAuthBrowser"));

  creator = Util.getOptionalAttribute(objid, 'creator', 'SIBAuthQueue');
  if creator is not None and len(creator) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthCreator", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthCreator._export(creator, currespath, "SIBAuthCreator"));

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthQueue');
  if identityAdopter is not None and len(identityAdopter) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthIdentityAdopter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthIdentityAdopter._export(identityAdopter, currespath, "SIBAuthIdentityAdopter"));

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthQueue');
  if receiver is not None and len(receiver) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthReceiver", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthReceiver._export(receiver, currespath, "SIBAuthReceiver"));

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthQueue');
  if sender is not None and len(sender) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthSender", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthSender._export(sender, currespath, "SIBAuthSender"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthQueue');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritDefaults", roleProperties.optString("websphere.sibauthqueue.inheritdefaults", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthqueue.identifier", None));
  print "Creating SIBAuthQueue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthQueue", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthBrowser":
        SIBAuthBrowser.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthCreator":
        SIBAuthCreator.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthReceiver":
        SIBAuthReceiver.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthQueue');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthqueue.inheritdefaults", None), "inheritDefaults","SIBAuthQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthqueue.identifier", None), "identifier","SIBAuthQueue");
  if len(atts) != 0:
    print "Modifying SIBAuthQueue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthQueue configuration up to date.";

  browser = Util.getOptionalAttribute(objid, 'browser', 'SIBAuthQueue');
  if browser is not None and len(browser) > 0:
    Util.remove(browser);

  creator = Util.getOptionalAttribute(objid, 'creator', 'SIBAuthQueue');
  if creator is not None and len(creator) > 0:
    Util.remove(creator);

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthQueue');
  if identityAdopter is not None and len(identityAdopter) > 0:
    Util.remove(identityAdopter);

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthQueue');
  if receiver is not None and len(receiver) > 0:
    Util.remove(receiver);

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthQueue');
  if sender is not None and len(sender) > 0:
    Util.remove(sender);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthBrowser":
        SIBAuthBrowser.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthCreator":
        SIBAuthCreator.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthReceiver":
        SIBAuthReceiver.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthQueue');
