from org.codehaus.jettison.json import JSONObject, JSONArray
from utilities import Util
from SIBPSBBrokerTransactionality import SIBPSBBrokerTransactionality
from SIBPSBTopicMapping import SIBPSBTopicMapping
from SIBPSBTopicTransactionality import SIBPSBTopicTransactionality

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBPSBBrokerProfile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBPSBBrokerProfile");
  exportedObject.put("roleName", "WebSphereSIBPSBBrokerProfile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbbrokerprofile.name", objid, "name","SIBPSBBrokerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbbrokerprofile.description", objid, "description","SIBPSBBrokerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbbrokerprofile.brokerqueuemanager", objid, "brokerQueueManager","SIBPSBBrokerProfile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  transactionality = Util.getOptionalAttribute(objid, 'transactionality', "SIBPSBBrokerProfile");
  if (transactionality is not None) and (len(transactionality) > 0):
    returndict = Util.createTypeFolder(respath, "SIBPSBBrokerTransactionality", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBPSBBrokerTransactionality._export(transactionality, currespath, "SIBPSBBrokerTransactionality"));

  i = 0;
  topicMappings = Util.parseConfigIdListAttribute(objid, 'topicMapping', "SIBPSBBrokerProfile");
  for topicMapping in topicMappings:
    if len(topicMapping) > 0:
      returndict = Util.createTypeFolder(respath, "SIBPSBTopicMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBPSBTopicMapping._export(topicMapping, currespath, "SIBPSBTopicMapping%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBPSBBrokerProfile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBPSBBrokerProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBBrokerProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibpsbbrokerprofile.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibpsbbrokerprofile.description", None));
  Util.addIfNotNone(properties, "brokerQueueManager", roleProperties.optString("websphere.sibpsbbrokerprofile.brokerqueuemanager", None));
  print "Creating SIBPSBBrokerProfile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBPSBBrokerProfile", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBPSBBrokerTransactionality":
        SIBPSBTopicTransactionality.create(objid, curjsonobject);
      elif currole == "WebSphereSIBPSBTopicMapping":
        SIBPSBTopicMapping.create(objid, curjsonobject);
  Util.popPathElement('SIBPSBBrokerProfile');

def update(objid,jsonobject):
  Util.pushPathElement('SIBPSBBrokerProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBBrokerProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbbrokerprofile.name", None), "name","SIBPSBBrokerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbbrokerprofile.description", None), "description","SIBPSBBrokerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbbrokerprofile.brokerqueuemanager", None), "brokerQueueManager","SIBPSBBrokerProfile");
  if len(atts) != 0:
    print "Modifying SIBPSBBrokerProfile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBPSBBrokerProfile configuration up to date.";

  transactionality = Util.getOptionalAttribute(objid, 'transactionality', "SIBPSBBrokerProfile");
  if (transactionality is not None) and (len(transactionality) > 0):
    Util.remove(transactionality);

  topicMappings = Util.parseConfigIdListAttribute(objid, 'topicMapping', "SIBPSBBrokerProfile");
  for topicMapping in topicMappings:
    Util.remove(topicMapping);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBPSBBrokerTransactionality":
        SIBPSBTopicTransactionality.create(objid, curjsonobject);
      elif currole == "WebSphereSIBPSBTopicMapping":
        SIBPSBTopicMapping.create(objid, curjsonobject);

  Util.popPathElement('SIBPSBBrokerProfile');
