from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSInboundService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSInboundService");
  exportedObject.put("roleName", "WebSphereSIBWSInboundService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundservice.name", objid, "name","SIBWSInboundService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundservice.description", objid, "description","SIBWSInboundService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundservice.enableoperationlevelsecurity", objid, "enableOperationLevelSecurity","SIBWSInboundService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundservice.servicedestinationname", objid, "serviceDestinationName","SIBWSInboundService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"SIBWSInboundService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSInboundService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSInboundService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSInboundService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwsinboundservice.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibwsinboundservice.description", None));
  Util.addIfNotNone(properties, "enableOperationLevelSecurity", roleProperties.optString("websphere.sibwsinboundservice.enableoperationlevelsecurity", None));
  Util.addIfNotNone(properties, "serviceDestinationName", roleProperties.optString("websphere.sibwsinboundservice.servicedestinationname", None));
  print "Creating SIBWSInboundService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSInboundService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSInboundService');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSInboundService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSInboundService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundservice.name", None), "name","SIBWSInboundService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundservice.description", None), "description","SIBWSInboundService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundservice.enableoperationlevelsecurity", None), "enableOperationLevelSecurity","SIBWSInboundService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundservice.servicedestinationname", None), "serviceDestinationName","SIBWSInboundService");
  if len(atts) != 0:
    print "Modifying SIBWSInboundService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSInboundService configuration up to date.";

  Property.removeProperties(objid, 'property',"SIBWSInboundService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSInboundService');
