from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBusMember import SIBusMember
from SIBForeignBus import SIBForeignBus
from SIBBootstrapMember import SIBBootstrapMember
from SIBPermittedChain import SIBPermittedChain
from SIBDestination import SIBDestination
from SIBQueue import SIBQueue
from SIBTopicSpace import SIBTopicSpace
from SIBDestinationAlias import SIBDestinationAlias
from SIBDestinationForeign import SIBDestinationForeign
from SIBAuthSpace import SIBAuthSpace
from Property import Property

__name_att__ = "websphere.sibus.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'SIBus');

  containmentpath = "%(parentconpath)sSIBus:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('SIBus')

  name = Util.getRequiredAttribute(objid, "name", 'SIBus');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBus");
  exportedObject.put("roleName", "WebSphereSIBus");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.usepermittedchains", objid, "usePermittedChains","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.securitygroupcachetimeout", objid, "securityGroupCacheTimeout","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.useserveridformediations", objid, "useServerIdForMediations","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.configurationreloadenabled", objid, "configurationReloadEnabled","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.protocol", objid, "protocol","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.discardmsgsafterqueuedeletion", objid, "discardMsgsAfterQueueDeletion","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.secure", objid, "secure","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.description", objid, "description","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.uuid", objid, "uuid","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.bootstrapmemberpolicy", objid, "bootstrapMemberPolicy","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.interengineauthalias", objid, "interEngineAuthAlias","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.highmessagethreshold", objid, "highMessageThreshold","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.mediationsauthalias", objid, "mediationsAuthAlias","SIBus");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibus.name", objid, "name","SIBus");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SIBus");
  permittedChains = Util.parseConfigIdListAttribute(objid, 'permittedChains',"SIBus");
  for permittedChain in permittedChains:
    if len(permittedChain) > 0:
      returndict = Util.createTypeFolder(respath, "SIBPermittedChain", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      permittedChainName = Util.getRequiredAttribute(permittedChain, "name", "SIBPermittedChain");
      Util.addAllFromExport(extraObjects, SIBPermittedChain._export(permittedChain, currespath, permittedChainName));

  i = 0;
  nominatedBootstrapMembers = Util.parseConfigIdListAttribute(objid, 'nominatedBootstrapMembers',"SIBus");
  for nominatedBootstrapMember in nominatedBootstrapMembers:
    if len(nominatedBootstrapMember) > 0:
      returndict = Util.createTypeFolder(respath, "SIBBootstrapMember", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBBootstrapMember._export(nominatedBootstrapMember, currespath, "SIB Bootstrap Member%s" % i));
      i = i + 1;

  i = 0;
  busMembers = Util.parseConfigIdListAttribute(objid, 'busMembers',"SIBus");
  for busMember in busMembers:
    if len(busMember) > 0:
      returndict = Util.createTypeFolder(respath, "SIBusMember", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBusMember._export(busMember, currespath, "SIBus Member%s" % i));
      i = i + 1;

  i = 0;
  foreignBuses = Util.parseConfigIdListAttribute(objid, 'foreignBus',"SIBus");
  for foreignBus in foreignBuses:
    if len(foreignBus) > 0:
      returndict = Util.createTypeFolder(respath, "SIBForeignBus", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      foreignBusName = Util.getRequiredAttribute(foreignBus, "name", "SIBForeignBus");
      Util.addAllFromExport(extraObjects, SIBForeignBus._export(foreignBus, currespath, foreignBusName));
      i = i + 1;

  queue = 0;   
  topicSpace = 0;  
  sibDestinations = SIBDestination.getSIBDestinations(objid);
  if sibDestinations is not None and len(sibDestinations) > 0:
    sibDestinationList = sibDestinations;
    for sibDestination in sibDestinationList:
      if len(sibDestination) > 0:
        returndict = Util.createTypeFolder(respath, "SIBDestination", typeFolders);
        currespath = returndict['path'];
        if returndict.has_key('object'):
          Util.addFromExport(extraObjects, returndict['object']);
        if sibDestination.find("#SIBQueue_") != -1:
          Util.addAllFromExport(extraObjects, SIBQueue._export(sibDestination, currespath, "SIBQueue%s" % queue));    
          queue = queue + 1;
        elif sibDestination.find("#SIBTopicSpace_") != -1:
          Util.addAllFromExport(extraObjects, SIBTopicSpace._export(sibDestination, currespath, "SIBTopicSpace%s" % topicSpace));      
          topicSpace = topicSpace + 1;

  i = 0;  
  sibDestinationAliases = SIBDestinationAlias.getSIBDestinationAlias(objid);
  if sibDestinationAliases is not None and len(sibDestinationAliases) > 0:
    sibDestinationAliasList = sibDestinationAliases;
    for sibDestinationAlias in sibDestinationAliasList:
      if len(sibDestinationAlias) > 0:
        returndict = Util.createTypeFolder(respath, "SIBDestination", typeFolders);
        currespath = returndict['path'];
        if returndict.has_key('object'):
          Util.addFromExport(extraObjects, returndict['object']);
        Util.addAllFromExport(extraObjects, SIBDestinationAlias._export(sibDestinationAlias, currespath, "SIBDestinationAlias%s" % i));    
        i = i + 1;

  i = 0;  
  sibDestinationForeigns = SIBDestinationForeign.getSIBDestinationForeigns(objid);
  if sibDestinationForeigns is not None and len(sibDestinationForeigns) > 0:
    sibDestinationForeignList = sibDestinationForeigns;
    for sibDestinationForeign in sibDestinationForeignList:
      if len(sibDestinationForeign) > 0:
        returndict = Util.createTypeFolder(respath, "SIBDestination", typeFolders);
        currespath = returndict['path'];
        if returndict.has_key('object'):
          Util.addFromExport(extraObjects, returndict['object']);
        Util.addAllFromExport(extraObjects, SIBDestinationForeign._export(sibDestinationForeign, currespath, "SIBDestinationForeign%s" % i));    
        i = i + 1;          

  i = 0;    
  sibAuthSpaces = SIBAuthSpace.getSIBAuthSpaces(objid);
  if sibAuthSpaces is not None and len(sibAuthSpaces) > 0:
    sibAuthSpaceList = sibAuthSpaces;
    for sibAuthSpace in sibAuthSpaceList:
      if len(sibAuthSpace) > 0:
        returndict = Util.createTypeFolder(respath, "SIBAuthSpace", typeFolders);
        currespath = returndict['path'];
        if returndict.has_key('object'):
          Util.addFromExport(extraObjects, returndict['object']);
        Util.addAllFromExport(extraObjects, SIBAuthSpace._export(sibAuthSpace, currespath, "SIBAuthSpace%s" % i));        
        i = i + 1;

        
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBus');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  return doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBus resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.sibus.name"):
    raise Exception("Resource role properties does not contain websphere.sibus.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create SIBus on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBus')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBus resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.sibus.name"):
    raise Exception("Resource role properties does not contain websphere.sibus.name!");

  properties = [];
  Util.addIfNotNone(properties, "usePermittedChains", roleProperties.optString("websphere.sibus.usepermittedchains", None));
  Util.addIfNotNone(properties, "securityGroupCacheTimeout", roleProperties.optString("websphere.sibus.securitygroupcachetimeout", None));
  Util.addIfNotNone(properties, "useServerIdForMediations", roleProperties.optString("websphere.sibus.useserveridformediations", None));
  Util.addIfNotNone(properties, "configurationReloadEnabled", roleProperties.optString("websphere.sibus.configurationreloadenabled", None));
  Util.addIfNotNone(properties, "protocol", roleProperties.optString("websphere.sibus.protocol", None));
  Util.addIfNotNone(properties, "discardMsgsAfterQueueDeletion", roleProperties.optString("websphere.sibus.discardmsgsafterqueuedeletion", None));
  Util.addIfNotNone(properties, "secure", roleProperties.optString("websphere.sibus.secure", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibus.description", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibus.uuid", None));
  Util.addIfNotNone(properties, "bootstrapMemberPolicy", roleProperties.optString("websphere.sibus.bootstrapmemberpolicy", None));
  Util.addIfNotNone(properties, "interEngineAuthAlias", roleProperties.optString("websphere.sibus.interengineauthalias", None));
  Util.addIfNotNone(properties, "highMessageThreshold", roleProperties.optString("websphere.sibus.highmessagethreshold", None));
  Util.addIfNotNone(properties, "mediationsAuthAlias", roleProperties.optString("websphere.sibus.mediationsauthalias", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibus.name", None));
  print "Creating SIBus with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBus", parentid, properties);

  sibDestinations = SIBDestination.getSIBDestinations(objid);
  if sibDestinations is not None and len(sibDestinations) > 0:
    sibDestinationList = sibDestinations;
    for sibDestination in sibDestinationList:
      if len(sibDestination) > 0:
        Util.remove(sibDestination);
        
  sibDestinationAliases = SIBDestinationAlias.getSIBDestinationAlias(objid);
  if sibDestinationAliases is not None and len(sibDestinationAliases) > 0:
    sibDestinationAliasList = sibDestinationAliases;
    for sibDestinationAlias in sibDestinationAliasList:
      if len(sibDestinationAlias) > 0:
        Util.remove(sibDestinationAlias);      

  sibDestinationForeigns = SIBDestinationForeign.getSIBDestinationForeigns(objid);
  if sibDestinationForeigns is not None and len(sibDestinationForeigns) > 0:
    sibDestinationForeignList = sibDestinationForeigns;
    for sibDestinationForeign in sibDestinationForeignList:
      if len(sibDestinationForeign) > 0:
        Util.remove(sibDestinationForeign);      

  sibAuthSpaces = SIBAuthSpace.getSIBAuthSpaces(objid);
  if sibAuthSpaces is not None and len(sibAuthSpaces) > 0:
    sibAuthSpaceList = sibAuthSpaces;
    for sibAuthSpace in sibAuthSpaceList:
      if len(sibAuthSpace) > 0:
        Util.remove(sibAuthSpace);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBusMember":
        SIBusMember.create(objid, curjsonobject);
        children.remove(curjsonobject);
      elif currole == "WebSphereSIBBootstrapMember":
        SIBBootstrapMember.create(objid, curjsonobject);
        children.remove(curjsonobject);
      elif currole == "WebSphereSIBPermittedChain":
        SIBPermittedChain.create(objid, curjsonobject);
        children.remove(curjsonobject);
      elif currole == "WebSphereSIBQueue":
        SIBQueue.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBTopicSpace":
        SIBTopicSpace.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBDestinationAlias":
        SIBDestinationAlias.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBDestinationForeign":
        SIBDestinationForeign.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBAuthSpace":
        SIBAuthSpace.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

    # SIBForeignBus MUST be created after SIBusMember because it may depend on it for references
    for curjsonobject in children[:]:
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBForeignBus":
        # check to see if it has a reference to another SIBForeignBus
        if curjsonobject.has('children'):
           for childjsonobject in Util.getHighestChildrenWithRole(curjsonobject.getJSONArray('children')):
             childcurrole = childjsonobject.getString('roleName');
             if childcurrole == "WebSphereSIBForeignBusRef":
                childRoleProperties = childjsonobject.getJSONObject("roleProperties");
                referencedSIBForeignBusName = childRoleProperties.optString("websphere.sibforeignbusref.name", None);

                # check to see if referenced SIBForeignBus exists
                parentSIBusName = objid.split('/buses/')[1].split('|')[0];
                referencedContainmentPath = "/SIBus:" + parentSIBusName + "/SIBForeignBus:" + referencedSIBForeignBusName + "/";
                referencedSIBForeignBus = Util.getid(referencedContainmentPath);

                # create the referenced SIBForeignBus if it doesn't exist
                if referencedSIBForeignBus == None or len(referencedSIBForeignBus) == 0:
                  subChildren = children;
                  for subjsonobject in subChildren[:]:
                    subcurrole = subjsonobject.getString('roleName');
                    if subcurrole == "WebSphereSIBForeignBus":
                      subChildRoleProperties = subjsonobject.getJSONObject("roleProperties");
                      sibForeignBusName = subChildRoleProperties.optString("websphere.sibforeignbus.name", None);
                      if sibForeignBusName == referencedSIBForeignBusName:
                        SIBForeignBus.create(objid, subjsonobject);
                        break;

        # create the SIBForeignBus
        # we may have already created it if it is referenced by another SIBForeignBus,
        # so check to see if it exists.  If it does, don't create it again.
        sibForeignBusRoleProperties = curjsonobject.getJSONObject("roleProperties");
        sibForeignBusName = sibForeignBusRoleProperties.optString("websphere.sibforeignbus.name", None);
        parentSIBusName = objid.split('/buses/')[1].split('|')[0];
        sibForeignBusContainmentPath = "/SIBus:" + parentSIBusName + "/SIBForeignBus:" + sibForeignBusName + "/";
        sibForeignBus = Util.getid(sibForeignBusContainmentPath);
        if sibForeignBus == None or len(sibForeignBus) == 0:
          SIBForeignBus.create(objid, curjsonobject);
  Util.popPathElement('SIBus');

  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SIBus')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBus resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.sibus.name"):
    raise Exception("Resource role properties does not contain websphere.sibus.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.usepermittedchains", None), "usePermittedChains","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.securitygroupcachetimeout", None), "securityGroupCacheTimeout","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.useserveridformediations", None), "useServerIdForMediations","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.configurationreloadenabled", None), "configurationReloadEnabled","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.protocol", None), "protocol","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.discardmsgsafterqueuedeletion", None), "discardMsgsAfterQueueDeletion","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.secure", None), "secure","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.description", None), "description","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.uuid", None), "uuid","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.bootstrapmemberpolicy", None), "bootstrapMemberPolicy","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.interengineauthalias", None), "interEngineAuthAlias","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.highmessagethreshold", None), "highMessageThreshold","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.mediationsauthalias", None), "mediationsAuthAlias","SIBus");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibus.name", None), "name","SIBus");
  if len(atts) != 0:
    print "Modifying SIBus with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBus configuration up to date.";

  nominatedBootstrapMembers = Util.parseConfigIdListAttribute(objid, 'nominatedBootstrapMembers',"SIBus");
  for nominatedBootstrapMember in nominatedBootstrapMembers:
    if len(nominatedBootstrapMember) > 0:
      Util.remove(nominatedBootstrapMember);

  permittedChains = Util.parseConfigIdListAttribute(objid, 'permittedChains',"SIBus");
  for permittedChain in permittedChains:
    if len(permittedChain) > 0:
      Util.remove(permittedChain)

  busMembers = Util.parseConfigIdListAttribute(objid, 'busMembers',"SIBus");
  for busMember in busMembers:
    if len(busMember) > 0:
      Util.remove(busMember);

  foreignBuses = Util.parseConfigIdListAttribute(objid, 'foreignBus',"SIBus");
  for foreignBus in foreignBuses:
    if len(foreignBus) > 0:
      Util.remove(foreignBus);

  sibDestinations = SIBDestination.getSIBDestinations(objid);
  if sibDestinations is not None and len(sibDestinations) > 0:
    sibDestinationList = sibDestinations;
    for sibDestination in sibDestinationList:
      if len(sibDestination) > 0:
        Util.remove(sibDestination);    

  sibDestinationAliases = SIBDestinationAlias.getSIBDestinationAlias(objid);
  if sibDestinationAliases is not None and len(sibDestinationAliases) > 0:
    sibDestinationAliasList = sibDestinationAliases;
    for sibDestinationAlias in sibDestinationAliasList:
      if len(sibDestinationAlias) > 0:
        Util.remove(sibDestinationAlias);      

  sibDestinationForeigns = SIBDestinationForeign.getSIBDestinationForeigns(objid);
  if sibDestinationForeigns is not None and len(sibDestinationForeigns) > 0:
    sibDestinationForeignList = sibDestinationForeigns;
    for sibDestinationForeign in sibDestinationForeignList:
      if len(sibDestinationForeign) > 0:
        Util.remove(sibDestinationForeign);              

  sibAuthSpaces = SIBAuthSpace.getSIBAuthSpaces(objid);
  if sibAuthSpaces is not None and len(sibAuthSpaces) > 0:
    sibAuthSpaceList = sibAuthSpaces;
    for sibAuthSpace in sibAuthSpaceList:
      if len(sibAuthSpace) > 0:
        Util.remove(sibAuthSpace);              

  Property.removeProperties(objid, 'properties',"SIBus");

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBusMember":
        SIBusMember.create(objid, curjsonobject);
        children.remove(curjsonobject);
      elif currole == "WebSphereSIBBootstrapMember":
        SIBBootstrapMember.create(objid, curjsonobject);
        children.remove(curjsonobject);
      elif currole == "WebSphereSIBPermittedChain":
        SIBPermittedChain.create(objid, curjsonobject);
        children.remove(curjsonobject);
      elif currole == "WebSphereSIBQueue":
        SIBQueue.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBTopicSpace":
        SIBTopicSpace.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBDestinationAlias":
        SIBDestinationAlias.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBDestinationForeign":
        SIBDestinationForeign.create(objid, curjsonobject);  
      elif currole == "WebSphereSIBAuthSpace":
        SIBAuthSpace.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

    # SIBForeignBus MUST be created after SIBusMember because it may depend on it for references
    for curjsonobject in children[:]:
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBForeignBus":
        # check to see if it has a reference to another SIBForeignBus
        if curjsonobject.has('children'):
           for childjsonobject in Util.getHighestChildrenWithRole(curjsonobject.getJSONArray('children')):
             childcurrole = childjsonobject.getString('roleName');
             if childcurrole == "WebSphereSIBForeignBusRef":
                childRoleProperties = childjsonobject.getJSONObject("roleProperties");
                referencedSIBForeignBusName = childRoleProperties.optString("websphere.sibforeignbusref.name", None);

                # check to see if referenced SIBForeignBus exists
                parentSIBusName = objid.split('/buses/')[1].split('|')[0];
                referencedContainmentPath = "/SIBus:" + parentSIBusName + "/SIBForeignBus:" + referencedSIBForeignBusName + "/";
                referencedSIBForeignBus = Util.getid(referencedContainmentPath);

                # create the referenced SIBForeignBus if it doesn't exist
                if referencedSIBForeignBus == None or len(referencedSIBForeignBus) == 0:
                  subChildren = children;
                  for subjsonobject in subChildren[:]:
                    subcurrole = subjsonobject.getString('roleName');
                    if subcurrole == "WebSphereSIBForeignBus":
                      subChildRoleProperties = subjsonobject.getJSONObject("roleProperties");
                      sibForeignBusName = subChildRoleProperties.optString("websphere.sibforeignbus.name", None);
                      if sibForeignBusName == referencedSIBForeignBusName:
                        SIBForeignBus.create(objid, subjsonobject);
                        break;

        # create the SIBForeignBus
        # we may have already created it if it is referenced by another SIBForeignBus,
        # so check to see if it exists.  If it does, don't create it again.
        sibForeignBusRoleProperties = curjsonobject.getJSONObject("roleProperties");
        sibForeignBusName = sibForeignBusRoleProperties.optString("websphere.sibforeignbus.name", None);
        parentSIBusName = objid.split('/buses/')[1].split('|')[0];
        sibForeignBusContainmentPath = "/SIBus:" + parentSIBusName + "/SIBForeignBus:" + sibForeignBusName + "/";
        sibForeignBus = Util.getid(sibForeignBusContainmentPath);
        if sibForeignBus == None or len(sibForeignBus) == 0:
          SIBForeignBus.create(objid, curjsonobject);

  Util.popPathElement('SIBus');
