from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.sibusmembertargetref.engineuuid"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBusMemberTargetRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "engineUuid", "SIBusMemberTarget");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered SIBusMemberTargetRef");
  exportedObject.put("roleName", "WebSphereSIBusMemberTargetRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmembertargetref.engineuuid", objid, "engineUuid","SIBusMemberTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBusMemberTargetRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBusMemberTargetRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.sibusmembertargetref.engineuuid"):
    raise Exception("Resource role properties does not contain websphere.sibusmembertargetref.engineuuid!");

  engineUuidDesired = roleProperties.optString("websphere.sibusmembertargetref.engineuuid", None);
  referencedSIBusMemberTarget = None;

  # get the name of the parent SIBus, so we may limit the scope of our search to
  # only SIBusMemberTargets that belong to the parent SIBus.
  # parentId format: MyTestSIBLinkRef(cells/CloudBurstCell_1/buses/MyTestSIBus|sib-bus.xml#SIBLinkRef_1431090851151)
  parentSIBusName = parentid.split('/buses/')[1].split('|')[0];
  containmentPath = "/SIBus:" + parentSIBusName + "/";
  parentSIBus = Util.getid(containmentPath);

  # get all SIBusMemberTargets that belong to the parent SIBus
  siBusMemberTargets = Util.getAssociatedObjects(parentSIBus, "SIBusMemberTarget");

  # go through the list of SIBusMemberTargets and find the one whose engineUuid = engineUuid of the referenced SIBusMember Target
  if siBusMemberTargets is not None and len(siBusMemberTargets) > 0:
    for siBusMemberTarget in siBusMemberTargets:
      engineUuid = Util.getRequiredAttribute(siBusMemberTarget, "engineUuid", "SIBusMemberTarget");
      if engineUuidDesired == engineUuid:
        referencedSIBusMemberTarget = siBusMemberTarget;
        break;

  if referencedSIBusMemberTarget == None or len(referencedSIBusMemberTarget) == 0:
      raise Exception("Could not find SIBusMemberTarget with engineUuid " + engineUuidDesired + "for SIBLinkRef " + parentid + ".");
  #no need to add path elements as the only parents directly add their path elements(SIBLinkRef) before calling into import
  Util.modify(parentid, [['engine', referencedSIBusMemberTarget]]);

