from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecurityProtocolConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecurityProtocolConfig");
  exportedObject.put("roleName", "WebSphereSecurityProtocolConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityprotocolconfig.sessiongcidletime", objid, "sessionGCIdleTime","SecurityProtocolConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityprotocolconfig.sessiongcinterval", objid, "sessionGCInterval","SecurityProtocolConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityprotocolconfig.stateful", objid, "stateful","SecurityProtocolConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecurityProtocolConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecurityProtocolConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityProtocolConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "sessionGCIdleTime", roleProperties.optString("websphere.securityprotocolconfig.sessiongcidletime", None));
  Util.addIfNotNone(properties, "sessionGCInterval", roleProperties.optString("websphere.securityprotocolconfig.sessiongcinterval", None));
  Util.addIfNotNone(properties, "stateful", roleProperties.optString("websphere.securityprotocolconfig.stateful", None));
  print "Creating SecurityProtocolConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecurityProtocolConfig", parentid, properties);
  Util.popPathElement('SecurityProtocolConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SecurityProtocolConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityProtocolConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityprotocolconfig.sessiongcidletime", None), "sessionGCIdleTime","SecurityProtocolConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityprotocolconfig.sessiongcinterval", None), "sessionGCInterval","SecurityProtocolConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityprotocolconfig.stateful", None), "stateful","SecurityProtocolConfig");
  if len(atts) != 0:
    print "Modifying SecurityProtocolConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecurityProtocolConfig configuration up to date.";

  Util.popPathElement('SecurityProtocolConfig');
